﻿--[[

-- Atlas Data (Traditional Chinese)
-- Translated and maintained by Arith Hsu
-- arithmandarjp at yahoo.co.jp
-- Special thanks for Alfred and his website "Alfred's WoW Treasure BOX"
-- http://statue.sayya.org/wowdb/index.php
--
-- Last Updated: 8/09/2007

--]]
if (GetLocale() == 	"zhTW") then

local BabbleBoss = AceLibrary("Babble-Boss-2.2");
local AL = AceLibrary("AceLocale-2.2"):new("AtlasLoot");

AtlasLoot_Data["AtlasLootExpansionItems"] = {

    EmptyInstance = {};

        ----------------------------
	--- Burning Crusade Keys ---
	----------------------------

    BCKeys = {
        { 0, "INV_Box_01", "=q6=#j1#", "" },
        { 27991, "INV_Misc_Key_02", "=q1=暗影迷宮鑰匙", "=ds=#e9#" },
        { 28395, "INV_Misc_Key_02", "=q1=破碎大廳鑰匙", "=ds=#e9#" },
	{ 31084, "INV_DataCrystal03", "=q1=亞克崔茲鑰匙", "=ds=#e9#" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#j3#", "" },
        { 30622, "INV_Misc_Key_13", "=q1=火鑄之鑰", "=ds=#e9# =q6=#m7#" },
        { 30637, "INV_Misc_Key_13", "=q1=火鑄之鑰", "=ds=#e9# =q6=#m6#" },
        { 30623, "INV_Misc_Key_13", "=q1=倉庫之鑰", "=ds=#e9#" },
        { 30633, "INV_Misc_Key_11", "=q1=奧奇奈鑰匙", "=ds=#e9#" },
	{ 30635, "INV_Misc_Key_04", "=q1=時光之鑰", "=ds=#e9#" },
        { 30634, "INV_Misc_Key_09", "=q1=扭曲鍛造鑰匙", "=ds=#e9#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6=#j2#", "" },
        { 32649, "INV_Jewelry_Amulet_04", "=q4=卡拉伯爾獎章", "=ds=#e9#, #s2#" },
        { 31704, "INV_DataCrystal11", "=q1=風暴之鑰", "=ds=#e9#" },
        { 24490, "INV_Misc_Key_07", "=q1=主人鑰匙", "=ds=#e9#" },
	};

        -------------------------------------------
	--- Hellfire Citadel: Hellfire Ramparts ---
	-------------------------------------------

    HCRampWatchkeeper = {
        { 24024, "INV_Shoulder_01", "=q3=秘法狂怒肩甲", "=ds=#s3#, #a1#", "14.69%" },
        { 24023, "INV_Bracer_07", "=q3=手段護腕", "=ds=#s8#, #a2#", "13.29%" },
        { 24022, "INV_Pants_Leather_15", "=q3=爭鬥者鱗片護腿", "=ds=#s11#, #a3#", "14.38%" },
        { 24021, "INV_Chest_Plate03", "=q3=聖光之觸胸甲", "=ds=#s5#, #a4#", "13.03%" },
        { 24020, "INV_Sword_63", "=q3=暗影撕裂長劍", "=ds=#h3#, #w10#", "13.09%" },
        { 0,"","","" },
        { 23881, "INV_Weapon_Shortblade_29", "=q1=卡爾古瑪之手", "=ds=#m3#", "100%" },
        };
        
    HCRampWatchkeeperHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30593, "INV_Jewelcrafting_NobleTopaz_03", "=q4=彩虹火焰蛋白石", "=ds=#e7#", "11.11%" },
        { 30594, "INV_Jewelcrafting_Talasite_03", "=q4=光輝的綠玉髓", "=ds=#e7#", "12.35%" },
        { 30592, "INV_Jewelcrafting_Talasite_03", "=q4=堅硬的綠玉髓", "=ds=#e7#", "8.64%" },
	{ 0,"","","" },
        { 27448, "INV_Misc_Cape_11", "=q3=永生者披風", "=ds=#s4#", "28.37%" },
        { 27451, "INV_Boots_Cloth_05", "=q3=黑暗行者長靴", "=ds=#s12#, #a1#", "16.61%" },
        { 27450, "INV_Boots_Chain_03", "=q3=野行者之靴", "=ds=#s12#, #a3#", "14.19%" },
        { 27447, "INV_Bracer_18", "=q3=公平獎勵護腕", "=ds=#s8#, #a4#", "13.84%" },
        { 27449, "INV_Shield_05", "=q3=血騎士防禦者", "=ds=#w8#", "13.15%" },
        };
    
    HCRampOmor = {
        { 24090, "INV_Gauntlets_10", "=q3=血污掠奪者護手", "=ds=#s9#, #a3#", "12.14%" },
        { 24091, "INV_Belt_33", "=q3=堅韌防禦者", "=ds=#s10#, #a4#", "12.67%" },
        { 24073, "INV_Jewelry_Necklace_22", "=q3=扼環頸鏈", "=ds=#s2#", "11.60%" },
        { 24096, "INV_Jewelry_Amulet_05", "=q3=心血祈禱珠串", "=ds=#s2#", "11.15%" },
        { 24094, "INV_Hammer_05", "=q3=心火戰錘", "=ds=#h2#, #w6#", "14.76%" },
        { 24069, "INV_Staff_46", "=q3=水晶火焰法杖", "=ds=#w9#", "12.43%" },
        { 0,"","","" },
        { 23886, "Ability_WarStomp", "=q1=歐瑪爾的蹄子", "=ds=#m3#", "100%" },
        };
        
    HCRampOmorHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 0,"","","" },
        { 27466, "INV_Helmet_70", "=q3=敏捷頭巾", "=ds=#s1#, #a1#", "12.10%" },
        { 27462, "INV_Bracer_13", "=q3=深紅陰暗護腕", "=ds=#s8#, #a1#", "7.12%" },
	{ 27467, "INV_Boots_Cloth_06", "=q3=沉默行者長靴", "=ds=#s12#, #a2#", "16.37%" },
        { 27478, "INV_Belt_09", "=q3=詛咒觸發腰帶", "=ds=#s10#, #a3#", "14.59%" },
        { 27539, "INV_Shoulder_37", "=q3=正義背負者護肩", "=ds=#s3#, #a4#", "8.90%" },
        { 27906, "INV_Chest_Plate08", "=q3=深紅鍛造胸甲", "#s5#, #a4#", "12.10%" },
        { 27464, "INV_Jewelry_Necklace_17", "=q3=歐瑪爾的堅固意志", "=ds=#s2#", "13.52%" },
        { 27895, "INV_Jewelry_Ring_50Naxxramas", "=q3=多稜指環", "=ds=#s13#", "11.74%" },
        { 27477, "INV_Staff_24", "=q3=法奧的淨化徽記", "=ds=#s15#", "10.32%" },
        { 27463, "INV_Weapon_Shortblade_31", "=q3=恐懼烈焰匕首", "=ds=#h1#, #w4#", "8.90%" },
        { 27476, "INV_Mace_44", "=q3=地獄之錘", "=ds=#h1#, #w6#", "9.25%" },
        { 0,"","","" },
        { 0,"","","" },
        { 30593, "INV_Jewelcrafting_NobleTopaz_03", "=q4=彩虹火焰蛋白石", "=ds=#e7#", "11.11%" },
        { 30594, "INV_Jewelcrafting_Talasite_03", "=q4=光輝的綠玉髓", "=ds=#e7#", "12.35%" },
        { 30592, "INV_Jewelcrafting_Talasite_03", "=q4=堅硬的綠玉髓", "=ds=#e7#", "8.64%" },
        { 0,"","","" },
        { 27465, "INV_Gauntlets_15", "=q3=法力蝕刻手套", "=ds=#s9#, #a1#", "11.74%" },
        };
        
    HCRampVazruden = {
        { 23892, "INV_Scroll_04", "=q1=不祥的信件", "=ds=#m2#", "100%" },
        };
        
    HCRampNazan = {
        { 23901, "INV_Misc_Head_Dragon_Red", "=q1=納桑之顱", "=ds=#m3#", "100%" },
        };
        
    HCRampFelIronChest = {
        { 24150, "INV_Misc_Cape_17", "=q3=摩克納薩爾迷霧斗篷", "=ds=#s4#", "15.65%" },
        { 24083, "INV_Pants_Plate_09", "=q3=生命馬褲", "=ds=#s11#, #a1#", "17.00%" },
        { 24063, "INV_Belt_29", "=q3=移形午夜腰帶", "=ds=#s10#, #a2#", "17.25%" },
        { 24046, "INV_Pants_Plate_10", "=q3=轟雷褶裙", "=ds=#s11#, #a3#", "15.96%" },
        { 24064, "INV_Boots_Plate_04", "=q3=鐵底重靴", "=ds=#s12#, #a4#", "13.80%" },
        { 24045, "INV_Jewelry_Ring_26", "=q3=復原指環", "=ds=#s13#", "14.44%" },
        { 24154, "INV_Jewelry_Ring_24", "=q3=巫術之戒", "=ds=#s13#", "13.23%" },
        { 24151, "INV_Jewelry_Ring_17", "=q3=摩克納薩爾之戒", "=ds=#s13#", "15.45%" },
        { 24044, "INV_Weapon_Halberd13", "=q3=地獄搶奪者", "=ds=#w7#", "13.91%" },
        { 24155, "INV_Staff_51", "=q3=烏索之爪", "=ds=#w9#", "16.21%" },     
        };
        
    HCRampFelIronChestHEROIC = {
        { 29264, "INV_Belt_22", "=q4=樹林修補者腰帶", "=ds=#s10#, #a2#", "16.05%" },
        { 32077, "Inv_Gauntlets_11", "=q4=狂怒灌注手套", "=ds=#s9#, #a3#" },
        { 29238, "INV_Belt_27", "=q4=獅心腰帶", "=ds=#s10#, #a4#", "14.81%" },
        { 29346, "INV_Sword_38", "=q4=邪齒除取者", "=ds=#h1#, #w4#", "5.56%" },
        { 0,"","","" },
        { 27452, "INV_Bracer_10", "=q3=聖光刻劃護腕", "=ds=#s8#, #a1#", "11.73%" },
        { 27461, "INV_Chest_Leather_08", "=q3=徘徊者胸甲", "=ds=#s5#, #a2#", "11.73%" },
        { 27456, "INV_Chest_Cloth_07", "=q3=自然之息外衣", "=ds=#s5#, #a2#", "19.75%" },
        { 27454, "INV_Shoulder_23", "=q3=熔岩肩甲", "=ds=#s3#, #a3#", "16.66%" },
        { 27458, "INV_Pants_Cloth_11", "=q3=海洋之歌褶裙", "=ds=#s11#, #a3#", "10.49%" },
        { 27455, "INV_Helmet_12", "=q3=鐵龍面罩", "=ds=#s1#, #a4#", "11.11%" },
        { 27459, "INV_Bracer_06", "=q3=膽量臂甲", "=ds=#s8#, #a4#", "10.49%" },
        { 27457, "INV_Gauntlets_09", "=q3=生命背負者護手", "=ds=#s9#, #a4#", "8.02%" },
        { 27453, "INV_Jewelry_Ring_38", "=q3=艾弗林的殺戮戒指", "=ds=#s13#", "14.20%" },
        { 27460, "INV_Jewelry_Ring_AhnQiraj_03", "=q3=搶奪者指環", "=ds=#s13#", "17.90%" },
        { 30593, "INV_Jewelcrafting_NobleTopaz_03", "=q4=彩虹火焰蛋白石", "=ds=#e7#", "11.11%" },
        { 30594, "INV_Jewelcrafting_Talasite_03", "=q4=光輝的綠玉髓", "=ds=#e7#", "12.35%" },
        { 30592, "INV_Jewelcrafting_Talasite_03", "=q4=堅硬的綠玉髓", "=ds=#e7#", "8.64%" },
        };

        -------------------------------------------
	--- Hellfire Citadel: The Blood Furnace ---
	-------------------------------------------

    HCFurnaceMaker = {
        { 24388, "INV_Belt_11", "=q3=颶風腰帶", "=ds=#s10#, #a3#", "15.84%" },
        { 24387, "INV_Gauntlets_03", "=q3=鐵劍護手", "=ds=#s9#, #a4#", "13.27%" },
        { 24385, "INV_Jewelry_Necklace_17", "=q3=戰爭貪欲墜飾", "=ds=#s2#", "15.43%" },
        { 24386, "INV_Misc_Book_13", "=q3=逝者聖契", "=ds=#s16#, #w16#", "14.78%" },
        { 24384, "INV_Mace_2H_Blacksmithing_03", "=q3=鑽石核心大錘", "=ds=#h3#, #w6#", "12.90%" },
        };

    HCFurnaceMakerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30601, "INV_Jewelcrafting_NobleTopaz_03", "=q4=發光的火焰蛋白石", "=ds=#e7#", "18.18%" },
        { 30600, "INV_Jewelcrafting_Nightseye_03", "=q4=螢光黝簾石", "=ds=#e7#", "9.85%" },
	{ 30602, "INV_Jewelcrafting_Talasite_03", "=q4=鋸齒綠玉髓", "=ds=#e7#", "12.12%" }, 
        { 0,"","","" },
        { 27485, "INV_Misc_Cape_18", "=q3=鑲邊神秘斗篷", "=ds=#s4#", "13.89%" },
        { 27488, "INV_Helmet_34", "=q3=火焰風暴之法師罩帽", "=ds=#s1#, #a1#", "16.67%" },
        { 27483, "INV_Bracer_08", "=q3=觸月護腕", "=ds=#s8#, #a2#", "25.00%" },
        { 27487, "INV_Pants_Plate_02", "=q3=血領主護腿", "=ds=#s11#, #a4#", "9.26%" },
        { 27484, "INV_Misc_StoneTablet_05", "=q3=復仇聖契", "=ds=#s16#, #w16#", "14.81%" },
	};
        
    HCFurnaceBroggok = {
        { 24392, "INV_Jewelry_Ring_35", "=q3=拱狀腕甲", "=ds=#s8#, #a1#", "14.37%" },
        { 24393, "INV_Misc_SurgeonGlove_01", "=q3=染血的外科醫生手套", "=ds=#s9#, #a1#", "17.62%" },
        { 24391, "INV_Pants_Leather_03", "=q3=夜行者褶裙", "=ds=#s11#, #a2#", "16.58%" },
        { 24390, "INV_Qiraj_JewelEncased", "=q3=奧斯雷的聖光引導器", "=ds=#s14#", "11.57%" },
        { 24389, "INV_Weapon_Rifle_17", "=q3=軍團喇叭槍", "=ds=#w5#", "17.69%" },
        };

    HCFurnaceBroggokHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30601, "INV_Jewelcrafting_NobleTopaz_03", "=q4=發光的火焰蛋白石", "=ds=#e7#", "18.18%" },
        { 30600, "INV_Jewelcrafting_Nightseye_03", "=q4=螢光黝簾石", "=ds=#e7#", "9.85%" },
	{ 30602, "INV_Jewelcrafting_Talasite_03", "=q4=鋸齒綠玉髓", "=ds=#e7#", "12.12%" }, 
        { 0,"","","" },
        { 27848, "INV_Boots_Cloth_06", "=q3=鑲邊法術柴堆長靴", "=ds=#s12#, #a1#", "8.33%" },
	{ 27492, "INV_Pants_Cloth_12", "=q3=月兒護腿", "=ds=#s11#, #a2#", "13.89%" },
        { 27489, "INV_Bracer_13", "=q3=貞潔先驅者臂鎧", "=ds=#s8#, #a4#", "22.22%" },
	{ 27491, "INV_Jewelry_Ring_59", "=q3=安寧之戒", "=ds=#s13#", "30.56%" },
        { 27490, "INV_Axe_65", "=q3=火炬戰斧", "=ds=#h1#, #w1#", "9.72%" },
	};
        
    HCFurnaceBreaker = {
        { 24397, "INV_Chest_Cloth_31", "=q3=神聖權威外衣", "=ds=#s5#, #a1#", "16.92%" },
        { 24395, "INV_Belt_10", "=q3=心靈之火護腕", "=ds=#s10#, #a1#", "16.64%" },
        { 24398, "INV_Shoulder_12", "=q3=暮色居民襯肩", "=ds=#s3#, #a2#", "14.29%" },
        { 24396, "INV_Chest_Leather_03", "=q3=復仇外衣", "=ds=#s5#, #a2#", "15.46%" },
        { 24394, "INV_Axe_61", "=q3=戰歌咆哮之斧", "=ds=#h2#, #w1#", "15.52%" },
        };

    HCFurnaceBreakerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 32080, "Inv_Shoulder_25", "=q4=暗擁襯肩", "=ds=#s3#, #a2#" },
	{ 29245, "INV_Boots_Chain_06", "=q4=浪峰遠行之靴", "=ds=#s12#, #a3#", "3.79%" },
        { 29239, "INV_Boots_Plate_01", "=q4=鷹頂戰靴", "=ds=#s12#, #a4#", "6.82%" },
        { 29347, "Ability_Hunter_MasterMarksman", "=q4=擊碎者護符", "=ds=#s2#", "7.58%" },
        { 0,"","","" },
	{ 27506, "INV_Chest_Cloth_38", "=q3=騰光長袍", "=ds=#s5#, #a1#", "17.42%" },
        { 27514, "INV_Pants_Leather_12", "=q3=頑固護腿", "=ds=#s12#, #a2#", "13.64%" },
        { 27522, "INV_Bracer_09", "=q3=世界盡頭護腕", "=ds=#s8#, #a3#", "25.76%" },
        { 27494, "INV_Bracer_16", "=q3=翡翠之眼護腕", "=ds=#s8#, #a3#", "11.50%" },
        { 27505, "INV_Helmet_12", "=q3=正義紅寶石頭盔", "=ds=#s1#, #a4#", "11.36%" },
        { 27495, "INV_Jewelry_Necklace_39", "=q3=士兵的識別證", "=ds=#s2#", "9.85%" },
        { 28121, "INV_BRD_Banner", "=q3=堅定勇氣塑像", "=ds=#s14#", "8.33%" },
        { 27512, "INV_Sword_01", "=q3=破志者", "=ds=#h3#, #w10#", "6.06%" },
        { 27507, "INV_Weapon_Crossbow_15", "=q3=艾曼泰強弩", "=ds=#w3#", "6.82%" },
        { 30601, "INV_Jewelcrafting_NobleTopaz_03", "=q4=發光的火焰蛋白石", "=ds=#e7#", "18.18%" },
        { 30600, "INV_Jewelcrafting_Nightseye_03", "=q4=螢光黝簾石", "=ds=#e7#", "9.85%" },
	{ 30602, "INV_Jewelcrafting_Talasite_03", "=q4=鋸齒綠玉髓", "=ds=#e7#", "12.12%" }, 
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28264, "INV_Chest_Chain_17", "=q3=荒行外衣", "=ds=#s5#, #a2# (D3)", "6.82%" },
	{ 27497, "INV_Gauntlets_29", "=q3=末日戰甲護手", "=ds=#s9#, #a4# (D3)", "9.09%" },
	};
        
        ------------------------------------------
	--- Coilfang Reservoir: The Slave Pens ---
	------------------------------------------

    CFRSlaveMennu = {
        { 24359, "INV_Pants_Cloth_16", "=q3=奢華統治護腿", "=ds=#s11#, #a1#", "10.20%" },
        { 24357, "INV_Chest_Cloth_06", "=q3=生命電光外衣", "=ds=#s5#, #a3#", "11.94%" },
        { 24360, "INV_Belt_11", "=q3=追蹤者腰帶", "=ds=#s10#, #a3#", "11.07%" },
        { 24356, "INV_Weapon_Shortblade_33", "=q3=荒行剃刀", "=ds=#h3#, #w4#", "12.47%" },
        { 24361, "INV_Sword_05", "=q3=魔焰長劍", "=ds=#h3#, #w10#", "11.07%" },
        { 0,"","","" },
        { 29674, "INV_Scroll_06", "=q2=圖樣:自然護甲片", "=ds=#p7# (340)", "0.80%" },
        };

    CFRSlaveMennuHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30604, "INV_Jewelcrafting_NobleTopaz_03", "=q4=光輝火豔蛋白石", "=ds=#e7#", "22.49%" },
	{ 30605, "INV_Jewelcrafting_Talasite_03", "=q4=鮮艷的綠玉髓", "=ds=#e7#", "9.39%" },
	{ 30603, "INV_Jewelcrafting_Nightseye_03", "=q4=皇家黝簾石", "=ds=#e7#", "10.48%" },
        { 0,"","","" },
        { 27542, "INV_Belt_30", "=q3=信仰腰帶", "=ds=#s10#, #a1#", "16.50%" },
	{ 27545, "INV_Pants_Mail_05", "=q3=曼紐之鱗片護腿", "=ds=#s11#, #a2#", "8.50%" },
        { 27541, "INV_Belt_25", "=q3=破碎者箭術腰帶", "=ds=#s10#, #a3#", "12.75%" },
        { 27546, "INV_Misc_Noose_01", "=q3=背叛套索", "=ds=#s2#", "13.75%" },
	{ 27544, "Spell_Nature_ProtectionformNature", "=q3=人工生長圖騰", "=ds=#s16#, #w15#", "12.25%" },
        { 27543, "INV_Weapon_Shortblade_37", "=q3=星光匕首", "=ds=#h3#, #w4#", "20.00%" },
	};
    
    CFRSlaveRokmar = {
        { 24379, "INV_Misc_Cape_06", "=q3=沼澤閃擊鱗片披風", "=ds=#s4#", "10.05%" },
        { 24376, "INV_Mushroom_06", "=q3=符文菌帽", "=ds=#s14#", "11.45%" },
        { 24378, "INV_Mace_40", "=q3=盤牙恢復之錘", "=ds=#h3#, #w6#", "9.66%" },
        { 24380, "INV_Wand_04", "=q3=冷靜孢子蘆葦", "=ds=#w12#", "10.26%" },
        { 24381, "INV_Weapon_Crossbow_11", "=q3=盤牙縫衣針", "=ds=#w3#", "10.05%" },
        };

    CFRSlaveRokmarHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30604, "INV_Jewelcrafting_NobleTopaz_03", "=q4=光輝火豔蛋白石", "=ds=#e7#", "22.49%" },
	{ 30605, "INV_Jewelcrafting_Talasite_03", "=q4=鮮艷的綠玉髓", "=ds=#e7#", "9.39%" },
	{ 30603, "INV_Jewelcrafting_Nightseye_03", "=q4=皇家黝簾石", "=ds=#e7#", "10.48%" },
        { 0,"","","" },
        { 27550, "INV_Misc_Cape_13", "=q3=鐵鱗戰爭披風", "=ds=#s4#", "11.48%" },
	{ 27547, "INV_Belt_15", "=q3=冷語腰帶", "=ds=#s10#, #a1#", "14.85%" },
	{ 28124, "INV_Belt_15", "=q3=騙子腰帶", "=ds=#s10#, #a2#", "8.96%" },
        { 27549, "INV_Boots_Chain_08", "=q3=怒浪長靴", "=ds=#s12#, #a3#", "9.80%" },
	{ 27548, "INV_Belt_23", "=q3=祝福滿盈腰帶", "=ds=#s10#, #a4#", "14.85%" },
	{ 27551, "INV_Jewelry_Talisman_12", "=q3=戰怒骷髏項鏈", "=ds=#s2#", "16.25%" },
	};
        
    CFRSlaveQuagmirran = {
        { 24362, "INV_Misc_Cape_16", "=q3=盈孢披風", "=ds=#s4#", "10.63%" },
        { 24365, "INV_Gauntlets_22", "=q3=靈巧護手", "=ds=#s9#, #a2#", "10.89%" },
        { 24366, "INV_Shoulder_03", "=q3=工蠍之刺襯肩", "=ds=#s3#, #a3#", "11.72%" },
        { 24363, "INV_Chest_Plate03", "=q3=無疤胸甲", "=ds=#s5#, #a4#", "9.54%" },
        { 24364, "INV_Pants_Mail_15", "=q3=藍色鎧甲護脛", "=ds=#s11#, #a4#", "9.98%" },
        };

    CFRSlaveQuagmirranHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 29242, "INV_Boots_Cloth_11", "=q4=褻瀆長靴", "=ds=#s12#, #a1#", "10.04%" },
        { 30538, "INV_Pants_Leather_09", "=q4=午夜護腿", "=ds=#s11#, #a2#", "8.95%" },
        { 32078, "Inv_Shoulder_33", "=q4=野性魔法肩鎧", "=ds=#s3#, #a3#" },
        { 29349, "INV_Jewelry_Necklace_06", "=q4=艾曼泰不壞之鏈", "=ds=#s2#", "1.53%" },
        { 0,"","","" },
        { 27712, "INV_Bracer_08", "=q3=奎克米瑞的手銬", "=ds=#s8#, #a2#" },
	{ 27800, "INV_Pants_14", "=q3=大地靈魂馬褲", "=ds=#s11#, #a2#", "13.76%" },
        { 28337, "INV_Chest_Plate08", "=q3=正義之怒胸甲", "=ds=#s5#, #a4#", "8.73%" },
	{ 27672, "INV_Belt_26", "=q3=靜止腰帶", "=ds=#s10#, #a4#", "7.64%" },
        { 27740, "INV_Jewelry_Ring_24", "=q3=烏索指環", "=ds=#s13#", "12.23%" },
        { 27683, "INV_Misc_Gem_Pearl_01", "=q3=奎克米瑞之眼", "=ds=#s14#", "7.86%" },
        { 27714, "INV_Offhand_OutlandRaid_03orange", "=q3=沼澤光明燈籠", "=ds=#s15#", "10.92%" },
        { 27673, "Inv_Sword_27", "=q3=磷光刃", "=ds=#h1#, #w10#" },
        { 27741, "INV_Mace_1H_Stratholme_D_01", "=q3=血之谷戰錘", "=ds=#h3#, #w6#", "9.83%" },
        { 30604, "INV_Jewelcrafting_NobleTopaz_03", "=q4=光輝火豔蛋白石", "=ds=#e7#", "22.49%" },
	{ 30605, "INV_Jewelcrafting_Talasite_03", "=q4=鮮艷的綠玉髓", "=ds=#e7#", "9.39%" },
	{ 30603, "INV_Jewelcrafting_Nightseye_03", "=q4=皇家黝簾石", "=ds=#e7#", "10.48%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27796, "INV_Shoulder_22", "=q3=法力蝕刻肩甲", "=ds=#s3#, #a1# (D3)", "5.24%" },
        { 27713, "INV_Shoulder_20", "=q3=荒漠肩甲", "=ds=#s3#, #a3# (D3)", "10.70%" },
	};
        
        ----------------------------------------
	--- Coilfang Reservoir: The Underbog ---
	----------------------------------------

    CFRUnderHungarfen = {
        { 24450, "INV_Gauntlets_14", "=q3=法力火花手套", "=ds=#s9#, #a1#", "11.72%" },
        { 24452, "INV_Gauntlets_21", "=q3=星光護手", "=ds=#s9#, #a2#", "12.35%" },
        { 24451, "INV_Jewelry_Ring_AhnQiraj_01", "=q3=萊庫血腕環", "=ds=#s8#, #a3#", "11.75%" },
        { 24413, "Spell_Nature_AbolishMagic", "=q3=雷爆圖騰", "=ds=#s16#, #w15#", "12.86%" },
        { 27631, "INV_ThrowingKnife_06", "=q3=針葉飛鏢", "=ds=#w11#", "11.60%" },
        };

    CFRUnderHungarfenHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30606, "INV_Jewelcrafting_Talasite_03", "=q4=柔光綠玉髓", "=ds=#e7#", "17.89%" },
        { 30607, "INV_Jewelcrafting_NobleTopaz_03", "=q4=絢麗火焰蛋白石", "=ds=#e7#", "6.50%" },
        { 30608, "INV_Jewelcrafting_Talasite_03", "=q4=輻光綠玉髓", "=ds=#e7#", "9.76%" },
        { 0,"","","" },
	{ 27746, "INV_Bracer_19", "=q3=奧金徽記指環", "=ds=#s8#, #a1#", "8.37%" },
        { 27745, "INV_Gauntlets_11", "=q3=飢餓皮手套", "=ds=#s9#, #a3#", "13.79%" },
	{ 27743, "INV_Belt_11", "=q3=持續燃燒腰帶", "=ds=#s10#, #a3#", "13.79%" },
        { 27748, "INV_Chest_Cloth_59", "=q3=忠誠長衣", "=ds=#s11#, #a4#", "7.39%" },
        { 27744, "Ability_Druid_DemoralizingRoar", "=q3=德魯伊塑像", "=ds=#s16#, #w14#", "16.26%" },
	{ 27747, "INV_Weapon_Hand_11", "=q3=沼澤脊椎指節", "=ds=#h4#, #w13#", "12.81%" },
	};
        
    CFRUnderGhazan = {
        { 24459, "INV_Misc_Cape_06", "=q3=治療光披風", "=ds=#s4#", "14.18%" },
        { 24458, "INV_Belt_01", "=q3=釘甲貞德腰帶", "=ds=#s10#, #a4#", "14.06%" },
        { 24460, "INV_Misc_EngGizmos_04", "=q3=堅韌護符", "=ds=#s2#", "12.99%" },
        { 24462, "INV_Jewelry_Necklace_10", "=q3=洞察夜光珍珠", "=ds=#s2#", "12.75%" },
        { 24461, "INV_Hammer_10", "=q3=仇恨者", "=ds=#h2#, #w6#", "14.12%" },
        };

    CFRUnderGhazanHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30606, "INV_Jewelcrafting_Talasite_03", "=q4=柔光綠玉髓", "=ds=#e7#", "17.89%" },
        { 30607, "INV_Jewelcrafting_NobleTopaz_03", "=q4=絢麗火焰蛋白石", "=ds=#e7#", "6.50%" },
        { 30608, "INV_Jewelcrafting_Talasite_03", "=q4=輻光綠玉髓", "=ds=#e7#", "9.76%" },
        { 0,"","","" },
	{ 27760, "INV_Belt_24", "=q3=沙丘之風腰帶", "=ds=#s10#, #a2#", "14.67%" },
	{ 27759, "INV_Helmet_19", "=q3=浪潮頭巾", "=ds=#s1#, #a3#", "13.33%" },
	{ 27755, "INV_Belt_29", "=q3=英豪腰帶", "=ds=#s10#, #a4#", "7.33%" },
        { 27758, "INV_Jewelry_Necklace_34", "=q3=海蛇牙項鍊", "=ds=#s2#", "12.00%" },
	{ 27761, "INV_jewelry_ring_AhnQiraj_01", "=q3=暗影深處之戒", "=ds=#s13#", "18.67%" },
        { 27757, "INV_Staff_56", "=q3=巨獸大法杖", "=ds=#w9#", "16.00%" },
	};
        
    CFRUnderSwamplord = {
        { 24454, "INV_Misc_Cape_13", "=q3=持久敏捷披風", "=ds=#s4#", "17.23%" },
        { 24455, "INV_Chest_Plate06", "=q3=守夜外套", "=ds=#s5#, #a2#", "14.47%" },
        { 24457, "INV_Shoulder_21", "=q3=真理護肩", "=ds=#s3#, #a4#", "14.42%" },
        { 24456, "INV_Pants_Mail_19", "=q3=鐵守衛護脛", "=ds=#s11#, #a4#", "12.41%" },
        { 24453, "INV_Weapon_ShortBlade_27", "=q3=贊格之牙短劍", "=ds=#h3#, #w4#", "15.17%" },
        };

    CFRUnderSwamplordHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30606, "INV_Jewelcrafting_Talasite_03", "=q4=柔光綠玉髓", "=ds=#e7#", "17.89%" },
        { 30607, "INV_Jewelcrafting_NobleTopaz_03", "=q4=絢麗火焰蛋白石", "=ds=#e7#", "6.50%" },
        { 30608, "INV_Jewelcrafting_Talasite_03", "=q4=輻光綠玉髓", "=ds=#e7#", "9.76%" },
        { 0,"","","" },
        { 27764, "INV_Gauntlets_19", "=q3=太陽護手", "=ds=#s9#, #a1#", "12.14%" },
	{ 27763, "INV_Helmet_17", "=q3=森林之王頭冠", "=ds=#s1#, #a2#", "20.00%" },
	{ 27765, "INV_Bracer_07", "=q3=驕傲外衣", "=ds=#s8#, #a2#", "9.29%" },
        { 27766, "INV_Jewelry_Necklace_29", "=q3=沼石項鏈", "=ds=#s2#", "17.14%" },
	{ 27767, "INV_Axe_55", "=q3=沼澤搶奪者", "=ds=#h1#, #w1#", "9.29%" },
	};
        
    CFRUnderStalker = {
        { 24481, "INV_Chest_Cloth_12", "=q3=占卜者長袍", "=ds=#s5#, #a1#", "10.55%" },
        { 24466, "INV_Pants_Mail_21", "=q3=鑿顱者護腿", "=ds=#s11#, #a2#", "13.23%" },
        { 24465, "INV_Chest_Chain_03", "=q3=搖晃之皮胸甲", "=ds=#s5#, #a3#", "10.95%" },
        { 24463, "INV_Shoulder_15", "=q3=蠻力肩甲", "=ds=#s3#, #a4#", "11.95%" },
        { 24464, "INV_Sword_53", "=q3=遠行者毒牙", "=ds=#h1#, #w4#", "14.31%" },
        { 0,"","","" },
        { 24248, "Spell_Shadow_Brainwash", "=q1=黑色捕獵者腦袋", "=ds=#m3#", "100%" },
        };

    CFRUnderStalkerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 29265, "INV_Boots_Chain_05", "=q4=樹皮碎片長靴", "=ds=#s12#, #a2#", "8.54%" },
        { 30541, "INV_Pants_Leather_03", "=q4=風暴之歌褶裙", "=ds=#s11#, #a3#", "6.50%" },
        { 32081, "INV_Jewelry_Ring_45", "=q4=靜行者之眼", "=ds=#s13#" },
	{ 29350, "INV_Wand_1H_Stratholme_D_01", "=q4=黑色獵捕魔杖", "=ds=#w12#", "4.88%" },
        { 0,"","","" },
	{ 27781, "INV_Helmet_72", "=q3=惡魔毒牙儀式頭盔", "=ds=#s1#, #a1#", "8.94%" },
        { 27768, "INV_Belt_01", "=q3=永恆之謎神諭腰帶", "=ds=#s10#, #a1#", "14.63%" },
        { 27938, "INV_Helmet_73", "=q3=山貓領主之野性面罩", "=ds=#s1#, #a2#", "1.63%" },
        { 27773, "INV_Pants_Leather_06", "=q3=野人裹腿", "=ds=#s11#, #a3#", "9.35%" },
        { 27779, "INV_Jewelry_Necklace_04", "=q3=白骨枷鎖項鍊", "=ds=#s2#", "14.23%" },
        { 27896, "INV_Potion_130", "=q3=地獄火力量淨化物", "=ds=#s14#", "12.60%" },
	{ 27770, "INV_Misc_ArmorKit_22", "=q3=阿格斯式羅盤", "=ds=#s14#", "3.66%" },
        { 27769, "INV_Sword_71", "=q3=終結者之劍", "=ds=#h2#, #w10#", "9.35%" },
	{ 27772, "INV_Shield_34", "=q3=恢復之風暴盾牌", "=ds=#w8#", "13.01%" },
        { 30606, "INV_Jewelcrafting_Talasite_03", "=q4=柔光綠玉髓", "=ds=#e7#", "17.89%" },
        { 30607, "INV_Jewelcrafting_NobleTopaz_03", "=q4=絢麗火焰蛋白石", "=ds=#e7#", "6.50%" },
        { 30608, "INV_Jewelcrafting_Talasite_03", "=q4=輻光綠玉髓", "=ds=#e7#", "9.76%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27907, "INV_Pants_Cloth_17", "=q3=法力蝕刻馬褲", "=ds=#s11#, #a1# (D3)", "4.88%" },
	{ 27771, "INV_Shoulder_26", "=q3=末日戰甲護肩", "=ds=#s3#, #a4# (D3)", "6.50%" },
	};
       
        ------------------------------
	--- Auchindoun: Mana-Tombs ---
	------------------------------
 
    AuchManaPandemonius = {
        { 25941, "INV_Boots_Chain_03", "=q3=外域者長靴", "=ds=#s12#, #a3#", "10.55%" },
        { 25942, "INV_Gauntlets_30", "=q3=信念懷抱者護手", "=ds=#s9#, #a4#", "11.41%" },
        { 25940, "INV_Relics_IdolofFerocity", "=q3=爪形塑像", "=ds=#s16#, #w14#", "12.18%" },
        { 25943, "INV_Weapon_ShortBlade_16", "=q3=戰慄武器", "=ds=#h3#, #w13#", "14.22%" },
        { 28166, "INV_Shield_13", "=q3=虛空之盾", "=ds=#w8#", "10.81%" },
        { 25939, "INV_Wand_06", "=q3=虛空之火焰魔杖", "=ds=#w12#", "13.04%" },
        };

    AuchManaPandemoniusHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30584, "INV_Jewelcrafting_NobleTopaz_03", "=q4=刻劃火焰蛋白石", "=ds=#e7#", "0.08%" },
	{ 30585, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃亮亮的火焰蛋白石", "=ds=#e7#", "6.06%" },
	{ 30583, "INV_Jewelcrafting_Talasite_03", "=q4=永恆綠玉髓", "=ds=#e7#", "9.09%" },
        { 0,"","","" },
	{ 27816, "INV_Shoulder_23", "=q3=心靈之怒肩甲", "=ds=#s3#, #a1#", "13.95%" },
	{ 27818, "INV_Chest_Cloth_08", "=q3=新月星袍", "=ds=#s5#, #a2#", "11.63%" },
	{ 27813, "INV_Boots_Chain_11", "=q3=巨像長靴", "=ds=#s12#, #a4#", "13.95%" },
        { 27815, "Spell_unused", "=q3=星風圖騰", "=ds=#s16#, #w15#", "2.33%" },
	{ 27814, "INV_Weapon_Shortblade_30", "=q3=精準雙刃", "=ds=#h1#, #w4#", "6.98%" },
	{ 27817, "INV_Weapon_Bow_06", "=q3=星光長弓", "=ds=#w2#", "9.30%" },
	};
        
    AuchManaTavarok = {
        { 25945, "INV_Misc_Cape_17", "=q3=復甦披風", "=ds=#s4#", "8.08%" },
        { 25946, "INV_Boots_Chain_06", "=q3=地獄陰影之靴", "=ds=#s12#, #a2#", "11.62%" },
        { 25947, "INV_Shoulder_17", "=q3=電光權杖護肩", "=ds=#s3#, #a3#", "11.25%" },
        { 25952, "INV_Sword_09", "=q3=奈薩斯捕獵者短彎刀", "=ds=#h1#, #w10#", "12.12%" },
        { 25944, "INV_Sword_82", "=q3=優良夏阿爾德之劍", "=ds=#h2#, #w10#", "9.35%" },
	{ 25950, "INV_Staff_13", "=q3=極性法杖", "=ds=#w9#", "9.91%" },
        };

    AuchManaTavarokHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30584, "INV_Jewelcrafting_NobleTopaz_03", "=q4=刻劃火焰蛋白石", "=ds=#e7#", "0.08%" },
	{ 30585, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃亮亮的火焰蛋白石", "=ds=#e7#", "6.06%" },
	{ 30583, "INV_Jewelcrafting_Talasite_03", "=q4=永恆綠玉髓", "=ds=#e7#", "9.09%" },
        { 0,"","","" },
	{ 27824, "INV_Chest_Cloth_38", "=q3=渾沌黑暗長袍", "=ds=#s5#, #a1#", "9.09%" },
	{ 27821, "INV_Boots_Cloth_12", "=q3=奢華的怨恨長靴", "=ds=#s12#, #a1#", "9.09%" },
	{ 27825, "INV_Gauntlets_15", "=q3=掠奪手套", "=ds=#s9#, #a2#", "15.15%" },
        { 27826, "INV_Shoulder_33", "=q3=海狼襯肩", "=ds=#s3#, #a3#", "3.03%" },
	{ 27823, "INV_Chest_Chain_13", "=q3=硬殼胸甲", "=ds=#s5#, #a3#", "15.15%" },
	{ 27822, "INV_Jewelry_Ring_54", "=q3=水晶勇氣指環", "=ds=#s13#", "15.15%" },
	};

    AuchManaNexusPrince = {
        { 25957, "INV_Boots_Cloth_02", "=q3=伊斯利天行者長靴", "=ds=#s12#, #a1#", "11.60%" },
	{ 25955, "INV_Helmet_57", "=q3=迷霧之魂", "=ds=#s1#, #a3#", "12.37%" },
        { 25956, "INV_Bracer_05", "=q3=活力之奈薩斯護腕", "=ds=#s8#, #a4#", "10.84%" },
        { 25954, "INV_SummerFest_Symbol_High", "=q3=薩法爾符印", "=ds=#s2#", "12.45%" },
        { 25962, "INV_Jewelry_Ring_44", "=q3=長途行者之環", "=ds=#s13#", "12.32%" },
        { 25953, "INV_Weapon_Bow_20", "=q3=伊斯利曲弓", "=ds=#w2#", "14.19%" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 22921, "INV_Scroll_06", "=q2=配方:極強效冰霜防護藥水", "=ds=#p1# (360)", "0.85%" },
	{ 0,"","","" },
	{ 28490, "INV_Misc_Bandage_Netherweave", "=q1=薩法爾裹帶", "=ds=#m3#", "100%" },
        };

    AuchManaNexusPrinceHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 29240, "INV_Bracer_12", "=q4=對立指環", "=ds=#s8#, #a1#", "3.03%" },
	{ 30535, "INV_Pants_Mail_08", "=q4=森林漫步者褶裙", "=ds=#s11#, #a2#", "27.27%" },
        { 29252, "INV_Bracer_02", "=q4=莊嚴護腕", "=ds=#s8#, #a4#", "3.03%" },
	{ 29352, "INV_Jewelry_Ring_57", "=q4=泰洛戈莎鈷藍指環", "=ds=#s13#", "0.21%" },
	{ 32082, "Inv_Shield_01", "=q4=惡魔屏障", "=ds=#w8#" },
	{ 0,"","","" },
        { 27843, "INV_Belt_10", "=q3=塑型腰帶", "=ds=#s10#, #a1#", "10.80%" },
	{ 27835, "INV_Belt_03", "=q3=止水腰帶", "=ds=#s10#, #a3#", "6.06%" },
	{ 27844, "INV_Shoulder_35", "=q3=迅捷獎懲肩甲", "=ds=#s3#, #a4#", "8.10%" },
	{ 27798, "INV_Gauntlets_19", "=q3=辯白護手", "=ds=#s9#, #a4#", "11.80%" },
	{ 0,"","","" },
	{ 22921, "INV_Scroll_06", "=q2=配方:極強效冰霜防護藥水", "=ds=#p1# (360)", "2.85%" },
	{ 0,"","","" },
	{ 0,"","","" },
        { 30584, "INV_Jewelcrafting_NobleTopaz_03", "=q4=刻劃火焰蛋白石", "=ds=#e7#", "0.08%" },
	{ 30585, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃亮亮的火焰蛋白石", "=ds=#e7#", "6.06%" },
	{ 30583, "INV_Jewelcrafting_Talasite_03", "=q4=永恆綠玉髓", "=ds=#e7#", "9.09%" },
	{ 0,"","","" },
	{ 27837, "INV_Pants_Mail_04", "=q3=荒行護腿", "=ds=#s11#, #a2# (D3)", "3.03%" },
	{ 0,"","","" },
	{ 27828, "INV_Scarab_Crystal", "=q3=扭曲甲蟲胸針", "=ds=#s14#", "30.30%" },
	{ 28400, "INV_Sword_51", "=q3=扭曲風暴戰刃", "=ds=#h1#, #w10#" },
	{ 27829, "INV_Axe_70", "=q3=奈薩斯王之斧", "=ds=#h2#, #w1#", "9.09%" },
	{ 27840, "INV_Mace_51", "=q3=薩塔權杖", "=ds=#h2#, #w6#" },
	{ 27842, "INV_Staff_45", "=q3=奈薩斯王的大權杖", "=ds=#w9#", "9.09%" },
	};

    AuchManaYor = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 31919, "Inv_Jewelry_Ring_53Naxxramas", "=q4=奈薩斯王子的平衡之戒", "=ds=#s13#" },
        { 31920, "Inv_Jewelry_Ring_51Naxxramas", "=q4=薩法爾的野蠻指環", "=ds=#s13#" },
        { 31921, "Inv_Jewelry_Ring_48Naxxramas", "=q4=猶爾的崩塌指環", "=ds=#s13#" },
        { 31922, "Inv_Jewelry_Ring_49Naxxramas", "=q4=衝突倖存之戒", "=ds=#s13#" },
        { 31923, "Inv_Jewelry_Ring_52Naxxramas", "=q4=水晶虛空之戒", "=ds=#s13#" },
        { 31924, "Inv_Jewelry_Ring_50Naxxramas", "=q4=猶爾的復仇之戒", "=ds=#s13#" },
        { 0,"","","" },
	{ 31554, "INV_Chest_Cloth_08", "=q3=導風者外衣", "=ds=#s5#, #a1# =q2=#m16#" },
	{ 31562, "INV_Chest_Leather_07", "=q3=天行者上衣", "=ds=#s5#, #a2# =q2=#m16#" },
	{ 31570, "INV_Chest_Chain_17", "=q3=霧幕外衣", "=ds=#s5#, #a3# =q2=#m16#" },
	{ 31578, "INV_Chest_Plate14", "=q3=岩鋼胸甲", "=ds=#s5# #a4#, =q2=#m16#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30584, "INV_Jewelcrafting_NobleTopaz_03", "=q4=刻劃火焰蛋白石", "=ds=#e7#", "0.08%" },
	{ 30585, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃亮亮的火焰蛋白石", "=ds=#e7#", "6.06%" },
	{ 30583, "INV_Jewelcrafting_Talasite_03", "=q4=永恆綠玉髓", "=ds=#e7#", "9.09%" },
	};

    AuchManaTrash = {
	{ 23615, "INV_Scroll_05", "=q3=設計圖:迅鋼手套", "=ds=#p2# (370), =q1=#n54#", "0.52%" },
	{ 0,"","","" },
	{ 22543, "INV_Misc_Note_01", "=q2=公式:附魔靴子 - 堅韌", "=ds=#p4# (320) =q1=#n83#", "0.52%" },
	};

        -----------------------------------
	--- Auchindoun: Auchenai Crypts ---
	-----------------------------------

    AuchCryptsShirrak = {
        { 27410, "INV_Helmet_06", "=q3=統御頭盔", "=ds=#s1#, #a1#", "13.00%" },
        { 27409, "INV_Helmet_21", "=q3=烏鴉之心頭飾", "=ds=#s1#, #a2#", "11.18%" },
        { 27408, "INV_Helmet_16", "=q3=希望持有者頭盔", "=ds=#s1#, #a4#", "15.16%" },
        { 26055, "INV_Jewelry_Ring_45", "=q3=隱密注視之眼", "=ds=#s14#", "15.16%" },
        { 25964, "INV_Sword_78", "=q3=次等夏阿爾德之劍", "=ds=#h3#, #w10#", "11.59%" },
        };

    AuchCryptsShirrakHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30587, "INV_Jewelcrafting_NobleTopaz_03", "=q4=勇士的火焰蛋白石", "=ds=#e7#", "11.67%" },
	{ 30588, "INV_Jewelcrafting_NobleTopaz_03", "=q4=強效火焰蛋白石", "=ds=#e7#", "1.67%" },
	{ 30586, "INV_Jewelcrafting_Talasite_03", "=q4=先知綠玉髓", "=ds=#e7#", "11.67%" },
        { 0,"","","" },
        { 27866, "INV_Helmet_52", "=q3=洞察之火花頭飾", "=ds=#s1#, #a1#", "15.00%" },
	{ 27493, "INV_Gauntlets_19", "=q3=死亡注視者手套", "=ds=#s9#, #a1#", "10.87%" },
	{ 27865, "INV_Bracer_16", "=q3=辛瑞克護腕", "=ds=#s8#, #a3#", "21.74%" },
	{ 27845, "INV_Boots_Chain_13", "=q3=地獄石之靴", "=ds=#s12#, #a3#", "23.91%" },
	{ 27847, "INV_Shoulder_34", "=q3=扇劍護肩", "=ds=#s3#, #a4#", "6.52%" },
        { 27846, "INV_Weapon_Hand_07", "=q3=看守者之爪", "=ds=#h3#, #w13#", "6.52%" },
	};

    AuchCryptsExarch = {
        { 27411, "INV_Boots_Cloth_14", "=q3=沉著便鞋", "=ds=#s12#, #a1#", "8.14%" },
        { 27415, "INV_Helmet_42", "=q3=黑暗守護面罩", "=ds=#s1#, #a2#", "11.44%" },
        { 27414, "INV_Helmet_19", "=q3=摩克納薩爾野獸面罩", "=ds=#s1#, #a3#", "11.27%" },
        { 27413, "INV_Jewelry_Ring_34", "=q3=主教之戒", "=ds=#s13#", "10.42%" },
        { 27416, "INV_Helmet_45", "=q3=墮落者神像", "=ds=#s14#", "12.81%" },
        { 27412, "INV_Staff_32", "=q3=新生鐵法杖", "=ds=#w9#", "11.95%" },
        };

    AuchCryptsExarchHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 29354, "INV_Misc_Cape_06", "=q4=聖光之觸利他披肩", "=ds=#s4#", "6.67%" },
        { 29257, "INV_Belt_03", "=q4=秘法視界腰帶", "=ds=#s10#, #a1#", "6.67%" },
        { 29244, "INV_Belt_22", "=q4=音浪腰帶", "=ds=#s10#, #a3#", "20.00%" },
        { 0,"","","" },
	{ 27867, "INV_Boots_Chain_06", "=q3=不義長靴", "=ds=#s12#, #a2#", "3.33%" },
	{ 27871, "Spell_Holy_SummonLightwell", "=q3=瑪拉達爾的祝福念珠", "=ds=#s2#", "18.33%" },
	{ 27869, "INV_Jewelry_Ring_38", "=q3=剛毅靈魂牧者指環", "=ds=#s13#", "18.33%" },
	{ 27523, "INV_Jewelry_Ring_55", "=q3=主教的鑽石戒指", "=ds=#s13#", "13.33%" },
	{ 27872, "INV_Axe_62", "=q3=鬼魂收割者", "=ds=#h1#, #w1#", "11.67%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30587, "INV_Jewelcrafting_NobleTopaz_03", "=q4=勇士的火焰蛋白石", "=ds=#e7#", "11.67%" },
	{ 30588, "INV_Jewelcrafting_NobleTopaz_03", "=q4=強效火焰蛋白石", "=ds=#e7#", "1.67%" },
	{ 30586, "INV_Jewelcrafting_Talasite_03", "=q4=先知綠玉髓", "=ds=#e7#", "11.67%" },
        { 0,"","","" },
        { 0,"","","" },
	{ 27870, "INV_Pants_Plate_12", "=q3=厄運鎧甲護腿", "=ds=#s11#, #a4# (D3)", "3.33%" },
	};

    AuchCryptsAvatar = {
        { 27878, "INV_Misc_Cape_21", "=q3=奧奇奈死亡披風", "=ds=#s4#", "4.41%" },
        { 28268, "INV_Gauntlets_21", "=q3=自然修補裹手", "=ds=#s9#, #a2#", "3.94%" },
        { 27876, "INV_Mace_08", "=q3=亡靈主教的意志", "=ds=#h3#, #w6#", "5.10%" },
        { 27937, "INV_Mace_34", "=q3=破天者", "=ds=#h3#, #w6#", "3.48%" },
        { 27877, "INV_Staff_42", "=q3=德萊尼野杖", "=ds=#w9#", "4.87%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27797, "INV_Shoulder_15", "=q3=荒行護肩", "=ds=#s3#, #a2# (D3)", "3.94%" },
        };

    AuchCryptsTrash = {
	{ 23605, "INV_Scroll_05", "=q3=設計圖:魔鋼手套", "=ds=#p2# (370), =q1=#n55#", "0.69%" },
	{ 0,"","","" },
	{ 22544, "INV_Misc_Note_01", "=q2=公式:附魔靴子 - 靈巧", "=ds=#p4# (340) =q1=#n82#", "0.60%" },
	};

        ---------------------------------
	--- Auchindoun: Sethekk Halls ---
	---------------------------------

    AuchSethekkDarkweaver = {
        { 27919, "INV_Boots_Cloth_02", "=q3=輕織便鞋", "=ds=#s12#, #a1#", "13.90%" },
        { 27914, "INV_Boots_Cloth_14", "=q3=月行者之靴", "=ds=#s12#, #a2#", "12.26%" },
        { 27915, "INV_Boots_Chain_05", "=q3=天獵迅捷之靴", "=ds=#s12#, #a3#", "11.74%" },
        { 27918, "INV_Bracer_10", "=q3=希斯指環", "=ds=#s8#, #a4#", "11.81%" },
        { 27917, "INV_Relics_LibramofTruth", "=q3=永恆安息聖契", "=ds=#s16#, #w16#", "14.12%" },
        { 27916, "INV_ThrowingKnife_06", "=q3=塞司克羽毛飛鏢", "=ds=#w11#", "11.34%" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
        { 24160, "INV_Scroll_05", "=q3=設計圖:火焰可利安指環", "=ds=#p12# (355)", "0.29%" },
        { 0,"","","" },
	{ 27633, "Inv_Helm_Mask_ZulGurub_D_01", "=q1=泰洛克面罩", "=ds=#m3#", "100%" },
        };

    AuchSethekkDarkweaverHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30553, "INV_Jewelcrafting_NobleTopaz_03", "=q4=原始火焰蛋白石", "=ds=#e7#", "15.73%" },
	{ 30554, "INV_Jewelcrafting_NobleTopaz_03", "=q4=堅定火焰蛋白石", "=ds=#e7#", "10.11%" },
	{ 30552, "INV_Jewelcrafting_Nightseye_03", "=q4=神聖黝簾石", "=ds=#e7#", "0.18%" },
	{ 0,"","","" },
        { 27919, "INV_Boots_Cloth_02", "=q3=輕織便鞋", "=ds=#s12#, #a1#", "6.32%" },
        { 27914, "INV_Boots_Cloth_14", "=q3=月行者之靴", "=ds=#s12#, #a2#", "17.89%" },
        { 27915, "INV_Boots_Chain_05", "=q3=天獵迅捷之靴", "=ds=#s12#, #a3#", "14.74%" },
        { 27918, "INV_Bracer_10", "=q3=希斯指環", "=ds=#s8#, #a4#", "10.53%" },
        { 27917, "INV_Relics_LibramofTruth", "=q3=永恆安息聖契", "=ds=#s16#, #w16#", "7.37%" },
        { 27916, "INV_ThrowingKnife_06", "=q3=塞司克羽毛飛鏢", "=ds=#w11#", "20.00%" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
        { 24160, "INV_Scroll_05", "=q3=設計圖:火焰可利安指環", "=ds=#p12# (355)", "0.29%" },
	{ 0,"","","" },
	{ 25461, "INV_Misc_Book_06", "=q1=遺忘之名魔典", "=ds=#m3#", "20.00%" },
	};
        
    AuchSethekkTalonKing = {
        { 27946, "INV_Misc_Cape_16", "=q3=鳥人羽毛斗篷", "=ds=#s4#", "10.21%" },
        { 27981, "INV_Misc_Cape_11", "=q3=塞司克智者披風", "=ds=#s4#", "10.00%" },
        { 27985, "INV_Belt_23", "=q3=亡鑄腰帶", "=ds=#s10#, #a4#", "9.24%" },
        { 27925, "INV_Jewelry_Ring_16", "=q3=鴉爪指環", "=ds=#s13#", "12.79%" },
        { 27980, "INV_Hammer_19", "=q3=泰洛克黑夜之錘", "=ds=#h1#, #w6#", "11.18%" },
        { 27986, "INV_Axe_69", "=q3=烏鴉之翼收割斧", "=ds=#h2#, #w1#", "8.50%" },
        { 0,"","","" },
	{ 27632, "INV_Spear_11", "=q1=泰洛克羽毛", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27948, "INV_Pants_08", "=q3=遺忘長褲", "=ds=#s11#, #a1# (D3)", "8.89%" },
	{ 27838, "INV_Pants_Cloth_20", "=q3=魔法使的長褲", "=ds=#s11#, #a1# (D3)", "9.54%" },
	{ 27875, "INV_Pants_Cloth_18", "=q3=神聖長褲", "=ds=#s11#, #a1# (D3)", "10.28%" },
	{ 27776, "INV_Shoulder_24", "=q3=暗殺護肩", "#s3#, #a2# (D3)", "10.21%" },
        { 27936, "INV_Pants_Cloth_20", "=q3=哀傷之鏈護脛", "=ds=#s11#, #a3# (D3)", "12.00%" },
        { 0,"","","" },
        { 0,"","","" },
        { 27991, "INV_Misc_Key_02", "=q1=暗影迷宮鑰匙", "=ds=#e9#", "100%" },
        };

    AuchSethekkTalonKingHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 29249, "INV_Bracer_13", "=q4=善行指環", "=ds=#s8#, #a1#", "4.49%" },
        { 29259, "INV_Bracer_02", "=q4=狩獵護腕", "=ds=#s8#, #a3#", "7.87%" },
        { 32073, "Inv_Shoulder_16", "=q4=戰狂肩鎧", "=ds=#s3#, #a4#" },
        { 29355, "INV_Weapon_Halberd19", "=q4=泰洛克暗影法杖", "=ds=#w9#", "0.16%" },
        { 0,"","","" },
        { 27946, "INV_Misc_Cape_16", "=q3=鳥人羽毛斗篷", "=ds=#s4#", "5.62%" },
        { 27981, "INV_Misc_Cape_11", "=q3=塞司克智者披風", "=ds=#s4#", "5.62%" },
        { 27985, "INV_Belt_23", "=q3=亡鑄腰帶", "=ds=#s10#, #a4#", "3.37%" },
        { 27925, "INV_Jewelry_Ring_16", "=q3=鴉爪指環", "=ds=#s13#", "11.24%" },
        { 27980, "INV_Hammer_19", "=q3=泰洛克黑夜之錘", "=ds=#h1#, #w6#", "5.62%" },
        { 27986, "INV_Axe_69", "=q3=烏鴉之翼收割斧", "=ds=#h2#, #w1#", "16.85%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30553, "INV_Jewelcrafting_NobleTopaz_03", "=q4=原始火焰蛋白石", "=ds=#e7#", "15.73%" },
	{ 30554, "INV_Jewelcrafting_NobleTopaz_03", "=q4=堅定火焰蛋白石", "=ds=#e7#", "10.11%" },
	{ 30552, "INV_Jewelcrafting_Nightseye_03", "=q4=神聖黝簾石", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27948, "INV_Pants_08", "=q3=遺忘長褲", "=ds=#s11#, #a1# (D3)", "8.99%" },
	{ 27838, "INV_Pants_Cloth_20", "=q3=魔法使的長褲", "=ds=#s11#, #a1# (D3)", "12.36%" },
	{ 27875, "INV_Pants_Cloth_18", "=q3=神聖長褲", "=ds=#s11#, #a1# (D3)", "15.73%" },
	{ 27776, "INV_Shoulder_24", "=q3=暗殺護肩", "#s3#, #a2# (D3)", "4.49%" },
        { 27936, "INV_Pants_Cloth_20", "=q3=哀傷之鏈護脛", "=ds=#s11#, #a3# (D3)", "19.10%" },
	};

    AuchSethekkRavenGod = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 32768, "INV-mount_Raven_54", "=q4=Reins of the Raven Lord", "=ds=#e12#" },
        { 30553, "INV_Jewelcrafting_NobleTopaz_03", "=q4=原始火焰蛋白石", "=ds=#e7#", "15.73%" },
	{ 30554, "INV_Jewelcrafting_NobleTopaz_03", "=q4=堅定火焰蛋白石", "=ds=#e7#", "10.11%" },
	{ 30552, "INV_Jewelcrafting_Nightseye_03", "=q4=神聖黝簾石", "=ds=#e7#", "0.18%" },
	{ 0,"","","" },
	{ 32769, "Inv_Belt_19", "=q3=烏鴉領主腰帶", "=ds=#s10#, #a2#" },
	{ 32778, "Inv_Boots_Plate_06", "=q3=公正剛毅長靴", "=ds=#s12#, #a4#" },
	{ 32779, "Inv_Jewelry_Ring_63", "=q3=嚴寒元素指環", "=ds=#s13#" },
	{ 32781, "Inv_Weapon_Shortblade_16", "=q3=安祖之爪", "=ds=#h3#, #w4#" },
	{ 32780, "Inv_Weapon_Rifle_22", "=q3=火槍", "=ds=#w5#" },
	};

    AuchSethekkTrash = {
	{ 25731, "INV_Scroll_05", "=q3=圖樣:造型紅色帽", "=ds=#p7# (350) =q1=#n84#", "0.46%" },
	{ 0,"","","" },
	{ 29669, "INV_Scroll_06", "=q2=圖樣:暗影護甲片", "=ds=#p7# (340) =q1=#n85#", "0.39%" },
	};

        ------------------------------------------------
	--- Caverns of Time: Old Hillsbrad Foothills ---
	------------------------------------------------

    CoTHillsbradDrake = {
        { 27423, "INV_Misc_Cape_18", "=q3=衝動披風", "=ds=#s4#", "19.68%" },
        { 27418, "INV_Pants_Leather_12", "=q3=風暴搶奪陰影褶裙", "=ds=#s11#, #a1#", "18.16%" },
        { 27417, "INV_Shoulder_17", "=q3=烏翼護肩", "=ds=#s3#, #a2#", "18.33%" },
        { 27420, "INV_Boots_Plate_02", "=q3=烏瑟的儀式戰靴", "=ds=#s12#, #a4#", "17.14%" },
        { 27436, "INV_Jewelry_Ring_30", "=q3=堅固鐵指環", "=ds=#s13#", "15.09%" },
        };

    CoTHillsbradDrakeHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30589, "INV_Jewelcrafting_Talasite_03", "=q4=燦爛的綠玉髓", "=ds=#e7#", "0.66%" },
	{ 30591, "INV_Jewelcrafting_NobleTopaz_03", "=q4=強能火焰蛋白石", "=ds=#e7#", "0.24%" },
	{ 30590, "INV_Jewelcrafting_Talasite_03", "=q4=耐久綠玉髓", "=ds=#e7#", "0.10%" },
	{ 0,"","","" },
	{ 28212, "INV_Pants_Cloth_14", "=q3=艾藍的巫術便褲", "=ds=#s11#, #a1#", "11.43%" },
	{ 28214, "INV_Gauntlets_07", "=q3=月蝕手套", "=ds=#s9#, #a2#", "2.86%" },
	{ 28215, "INV_Helmet_72", "=q3=摩克納薩爾戰鬥面罩", "=ds=#s1#, #a3#", "11.43%" },
	{ 28211, "INV_Jewelry_Ring_10", "=q3=中尉的羅德隆徽記", "=ds=#s13#", "5.71%" },
	{ 28213, "INV_Misc_Book_10", "=q3=羅德隆醫療指導", "=ds=#s15#", "8.57%" },
	{ 28210, "INV_Mace_44", "=q3=血顱摧毀者", "=ds=#h1#, #w6#", "5.71%" },
        };

    CoTHillsbradSkarloc = {
        { 27428, "INV_Gauntlets_26", "=q3=風暴之緣護手", "=ds=#s9#, #a3#", "19.04%" },
        { 27430, "INV_Pants_Plate_21", "=q3=耐性綴鱗護脛", "=ds=#s11#, #a3#", "19.22%" },
        { 27427, "INV_Chest_Chain_12", "=q3=杜洛坦的戰鬥背心", "=ds=#s5#, #a4#", "14.83%" },
        { 27424, "INV_Axe_15", "=q3=阿曼尼毒斧", "=ds=#h1#, #w1#", "18.50%" },
        { 27426, "INV_Mace_55", "=q3=北郡戰錘", "=ds=#h3#, #w6#", "15.37%" },
        { 0,"","","" },
        { 22927, "INV_Scroll_06", "=q2=配方:鐵盾藥水", "=ds=#p1# (365)", "1.03%" },
        };

    CoTHillsbradSkarlocHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30589, "INV_Jewelcrafting_Talasite_03", "=q4=燦爛的綠玉髓", "=ds=#e7#", "0.66%" },
	{ 30591, "INV_Jewelcrafting_NobleTopaz_03", "=q4=強能火焰蛋白石", "=ds=#e7#", "0.24%" },
	{ 30590, "INV_Jewelcrafting_Talasite_03", "=q4=耐久綠玉髓", "=ds=#e7#", "0.10%" },
	{ 0,"","","" },
	{ 28218, "INV_Pants_Cloth_18", "=q3=預言主教馬褲", "=ds=#s11#, #a1#", "18.18%" },
	{ 28220, "INV_Helmet_24", "=q3=月冠鹿角", "=ds=#s1#, #a2#", "0.14%" },
	{ 28219, "INV_Pants_Mail_16", "=q3=綠鱗護脛", "=ds=#s11#, #a3#", "3.03%" },
	{ 28221, "INV_Boots_Chain_08", "=q3=警戒之心長靴", "=ds=#s12#, #a4#", "0.52%" },
	{ 28217, "INV_Trinket_HonorHold", "=q3=塔倫米爾活力小墜子", "=ds=#s2#", "9.09%" },
	{ 28216, "INV_Hammer_11", "=q3=達索漢的典禮之錘", "=ds=#h3#, #w6#", "6.06%" },
        };

    CoTHillsbradHunter = {
        { 24173, "INV_Scroll_05", "=q4=設計圖:秘法之力頭環", "=ds=#p12# (370)", "0.10%" },
        { 0,"","","" },
        { 27433, "INV_Shoulder_26", "=q3=容忍肩甲", "=ds=#s3#, #a1#", "19.11%" },
        { 27434, "INV_Shoulder_35", "=q3=匹瑞諾德襯肩", "=ds=#s3#, #a2#", "16.26%" },
        { 27440, "INV_Misc_Gem_Diamond_01", "=q3=復發鑽石稜柱", "=ds=#s2#", "16.12%" },
        { 27432, "INV_Jewelry_Ring_53Naxxramas", "=q3=布拉席格的勇氣之戒", "=ds=#s13#", "16.35%" },
        { 27431, "INV_Weapon_Shortblade_33", "=q3=時光之盾匕首", "=ds=#h3#, #w4#", "14.09%" },
        };

    CoTHillsbradHunterHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 29250, "INV_Belt_15", "=q4=神聖腰帶", "=ds=#s10#, #a1#" },
	{ 29246, "INV_Bracer_15", "=q4=夜暮護腕", "=ds=#s8#, #a2#" },
	{ 29357, "INV_Gauntlets_22", "=q4=大師級竊盜手套", "=ds=#s9#, #a2#", "10.00%" },
	{ 30536, "INV_Pants_Plate_21", "=q4=殉難者護脛", "=ds=#s11#, #a4#", "15.00%" },
	{ 0,"","","" },
	{ 27911, "INV_Belt_19", "=q3=新紀元私語腰帶", "=ds=#s10#, #a2#", "10.00%" },
	{ 28344, "INV_Shoulder_18", "=q3=龍怒肩鎧", "=ds=#s3#, #a3#", "0.24%" },
	{ 28233, "INV_Jewelry_Necklace_12", "=q3=璀璨希望項鏈", "=ds=#s2#", "15.00%" },
	{ 27904, "INV_Jewelry_Ring_64", "=q3=光榮響亮之戒", "=ds=#s13#", "0.17%" },
	{ 28227, "INV_Jewelry_Ring_63", "=q3=閃光秘法戒指", "=ds=#s13#", "0.24%" },
	{ 28223, "INV_Jewelcrafting_Nightseye_01", "=q3=祕法師之石", "=ds=#s14#", "10.00%" },
	{ 28226, "INV_Weapon_Shortblade_51", "=q3=時光分割者", "=ds=#h1#, #w4#", "5.00%" },
	{ 28222, "INV_Axe_71", "=q3=無盡搶奪者", "=ds=#h2#, #w1#", "0.48%" },
	{ 0,"","","" },
	{ 30589, "INV_Jewelcrafting_Talasite_03", "=q4=燦爛的綠玉髓", "=ds=#e7#", "0.66%" },
	{ 30591, "INV_Jewelcrafting_NobleTopaz_03", "=q4=強能火焰蛋白石", "=ds=#e7#", "0.24%" },
	{ 30590, "INV_Jewelcrafting_Talasite_03", "=q4=耐久綠玉髓", "=ds=#e7#", "0.10%" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 28191, "INV_Chest_Cloth_42", "=q3=法力蝕刻祭袍", "=ds=#s5#, #a1# (D3)", "0.24%" },
	{ 28224, "INV_Helmet_15", "=q3=荒行頭盔", "=ds=#s1#, #a2# (D3)", "0.24%" },
	{ 28401, "INV_Chest_Chain_03", "=q3=哀傷之鏈鎖甲", "=ds=#s5#, #a3# (D3)", "0.14%" },
	{ 28225, "INV_Helmet_20", "=q3=末日戰甲頭盔", "=ds=#s1#, #a4# (D3)", "0.14%" },
        };

    CoTHillsbradTrash = {
	{ 25729, "INV_Scroll_05", "=q3=圖樣:造型旅行帽", "=ds=#p7# (350) =q1=#n94#", "0.25%" },
	};

        ------------------------------------
	--- Auchindoun: Shadow Labyrinth ---
	------------------------------------

    AuchShadowHellmaw = {
        { 27889, "INV_Gauntlets_19", "=q3=碧火殲滅手套", "=ds=#s9#, #a1#", "13.58%" },
        { 27888, "INV_Helmet_21", "=q3=夢翼頭盔", "=ds=#s1#, #a3#", "11.81%" },
        { 27884, "INV_Boots_Chain_04", "=q3=神化華麗之靴", "=ds=#s12#, #a4#", "13.15%" },
        { 27886, "Spell_Nature_NatureResistanceTotem", "=q3=祖母綠皇后塑像", "=ds=#s16#, #w14#", "12.94%" },
        { 27887, "INV_Shield_35", "=q3=勇氣白金盾牌", "=ds=#w8#", "10.88%" },
        { 27885, "INV_Wand_05", "=q3=奧多爾靈魂魔杖", "=ds=#w12#", "13.34%" },
        };

    AuchShadowHellmawHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30563, "INV_Jewelcrafting_Nightseye_03", "=q4=華麗黝簾石", "=ds=#e7#", "16.67%" },
        { 30559, "INV_Jewelcrafting_NobleTopaz_03", "=q4=蝕刻火焰蛋白石", "=ds=#e7#", "17.85%" },
        { 30560, "INV_Jewelcrafting_Talasite_03", "=q4=符文表面的綠玉髓", "=ds=#e7#", "15.47%" },
	{ 0,"","","" },
        { 27889, "INV_Gauntlets_19", "=q3=碧火殲滅手套", "=ds=#s9#, #a1#", "14.47%" },
        { 27888, "INV_Helmet_21", "=q3=夢翼頭盔", "=ds=#s1#, #a3#", "10.53%" },
        { 27884, "INV_Boots_Chain_04", "=q3=神化華麗之靴", "=ds=#s12#, #a4#", "18.42%" },
        { 27886, "Spell_Nature_NatureResistanceTotem", "=q3=祖母綠皇后塑像", "=ds=#s16#, #w14#", "10.53%" },
        { 27887, "INV_Shield_35", "=q3=勇氣白金盾牌", "=ds=#w8#", "11.84%" },
        { 27885, "INV_Wand_05", "=q3=奧多爾靈魂魔杖", "=ds=#w12#", "10.53%" },
        };

    AuchShadowBlackheart = {
        { 27892, "INV_Misc_Cape_08", "=q3=煽動者披風", "=ds=#s4#", "16.32%" },
        { 27893, "INV_Pants_Plate_21", "=q3=尊敬之華麗護腿", "=ds=#s11#, #a4#", "13.35%" },
        { 28134, "INV_Jewelry_Necklace_27", "=q3=提升潛能胸針", "=ds=#s2#", "10.54%" },
        { 27891, "INV_QirajIdol_Sage", "=q3=艾曼泰雕像", "=ds=#s14#", "10.93%" },
        { 27890, "INV_Wand_19", "=q3=虛空之翼魔杖", "=ds=#w12#", "10.77%" },
	{ 0,"","","" },
        { 25728, "INV_Scroll_05", "=q3=圖樣:造型紫色帽", "=ds=#p7# (350)", "0.94%" },
        { 0,"","","" },
        { 30808, "INV_Misc_Book_06", "=q1=地獄之名魔典", "=ds=#m3#", "100%" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 27468, "INV_Gauntlets_13", "=q3=月林裹手", "=ds=#s9#, #a2# (D3)", "10.93%" },
        };

    AuchShadowBlackheartHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30563, "INV_Jewelcrafting_Nightseye_03", "=q4=華麗黝簾石", "=ds=#e7#", "16.67%" },
        { 30559, "INV_Jewelcrafting_NobleTopaz_03", "=q4=蝕刻火焰蛋白石", "=ds=#e7#", "17.85%" },
        { 30560, "INV_Jewelcrafting_Talasite_03", "=q4=符文表面的綠玉髓", "=ds=#e7#", "15.47%" },
	{ 0,"","","" },
        { 27892, "INV_Misc_Cape_08", "=q3=煽動者披風", "=ds=#s4#", "26.67%" },
        { 27893, "INV_Pants_Plate_21", "=q3=尊敬之華麗護腿", "=ds=#s11#, #a4#", "6.67%" },
        { 28134, "INV_Jewelry_Necklace_27", "=q3=提升潛能胸針", "=ds=#s2#", "6.67%" },
        { 27891, "INV_QirajIdol_Sage", "=q3=艾曼泰雕像", "=ds=#s14#", "6.67%" },
        { 27890, "INV_Wand_19", "=q3=虛空之翼魔杖", "=ds=#w12#", "20.00%" },
	{ 0,"","","" },
        { 25728, "INV_Scroll_05", "=q3=圖樣:造型紫色帽", "=ds=#p7# (350)", "0.94%" },
        { 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 27468, "INV_Gauntlets_13", "=q3=月林裹手", "=ds=#s9#, #a2# (D3)", "6.67%" },
        };

    AuchShadowGrandmaster = {
        { 27897, "INV_Chest_Plate11", "=q3=恩典滿溢胸甲", "=ds=#s5#, #a4#", "12.67%" },
        { 27900, "INV_Misc_Gem_LionsEye_01", "=q3=有吸引力的神秘珠寶", "=ds=#s14#", "16.64%" },
        { 27901, "INV_Mace_35", "=q3=黑暗權杖", "=ds=#h1#, #w6#", "14.35%" },
        { 27898, "INV_Weapon_Rifle_20", "=q3=怒火手持火炮", "=ds=#w5#", "14.71%" },
        { 0,"","","" },
        { 30827, "INV_Misc_Book_01", "=q1=惡魔詞典", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27775, "INV_Shoulder_22", "=q3=神聖護肩", "=ds=#s3#, #a1# (D3)", "16.11%" },
        };

    AuchShadowGrandmasterHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30563, "INV_Jewelcrafting_Nightseye_03", "=q4=華麗黝簾石", "=ds=#e7#", "16.67%" },
        { 30559, "INV_Jewelcrafting_NobleTopaz_03", "=q4=蝕刻火焰蛋白石", "=ds=#e7#", "17.85%" },
        { 30560, "INV_Jewelcrafting_Talasite_03", "=q4=符文表面的綠玉髓", "=ds=#e7#", "15.47%" },
	{ 0,"","","" },
        { 27897, "INV_Chest_Plate11", "=q3=恩典滿溢胸甲", "=ds=#s5#, #a4#", "15.79%" },
        { 27900, "INV_Misc_Gem_LionsEye_01", "=q3=有吸引力的神秘珠寶", "=ds=#s14#", "26.32%" },
        { 27901, "INV_Mace_35", "=q3=黑暗權杖", "=ds=#h1#, #w6#", "5.26%" },
        { 27898, "INV_Weapon_Rifle_20", "=q3=怒火手持火炮", "=ds=#w5#", "8.77%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27775, "INV_Shoulder_22", "=q3=神聖護肩", "=ds=#s3#, #a1# (D3)", "19.30%" },
        };

    AuchShadowMurmur = {
        { 24309, "INV_Scroll_05", "=q4=圖樣:法擊短褲", "=ds=#p8# (375)", "0.37%" },
        { 0,"","","" },
        { 27902, "INV_Boots_Cloth_09", "=q3=冥想沉默便鞋", "=ds=#s12#, #a1#", "12.28%" },
        { 27912, "INV_Chest_Leather_05", "=q3=深流背心", "=ds=#s5#, #a3#", "13.59%" },
        { 27913, "INV_Weapon_Shortblade_51", "=q3=耳語屠殺之刃", "=ds=#h1#, #w4#", "9.69%" },
        { 27905, "INV_Sword_2H_Blood_C_03", "=q3=恐怖夢境之劍", "=ds=#h3#, #w10#", "9.35%" },
        { 27903, "INV_Spear_08", "=q3=音速之矛", "=ds=#w7#", "11.17%" },
        { 27910, "INV_Shield_36", "=q3=銀月羽飾盾牌", "=ds=#w8#", "12.46%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
	{ 27778, "INV_Shoulder_18", "=q3=遺忘護肩", "=ds=#s3#, #a1# (D3)", "12.28%" },
	{ 28232, "INV_Chest_Cloth_29", "=q3=赦免長袍", "=ds=#s5#, #a1# (D3)", "10.47%" },
	{ 28230, "INV_Chest_Cloth_39", "=q3=神聖服飾", "=ds=#s5#, #a1# (D3)", "11.46%" },
        { 27908, "INV_Pants_Leather_03", "=q3=刺殺護腿", "=ds=#s11#, #a2# (D3)", "8.76%" },
        { 27909, "INV_Pants_Mail_06", "=q3=惡潮褶裙", "=ds=#s11#, #a3# (D3)", "13.87%" },
        { 27803, "INV_Shoulder_26", "=q3=勇猛護肩", "=ds=#s3#, #a4# (D3)", "9.49%" },
        };

    AuchShadowMurmurHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 29241, "INV_Belt_03", "=q4=墮落腰帶", "=ds=#s10#, #a1#", "15.47%" },
        { 30532, "INV_Pants_Cloth_16", "=q4=肯瑞托大師長褲", "=ds=#s11#, #a1#", "11.90%" },
	{ 29357, "INV_Gauntlets_22", "=q4=大師級竊盜手套", "=ds=#s9#, #a2#" },
        { 29261, "INV_Belt_30", "=q4=兇猛腰帶", "=ds=#s10#, #a3#", "3.57%" },
        { 29353, "INV_Mace_54", "=q4=震浪之錘", "=ds=#h3#, #w6#", "10.71%" },
	{ 0,"","","" },
        { 27902, "INV_Boots_Cloth_09", "=q3=冥想沉默便鞋", "=ds=#s12#, #a1#", "4.76%" },
        { 27912, "INV_Chest_Leather_05", "=q3=深流背心", "=ds=#s5#, #a3#", "13.59%" },
        { 27913, "INV_Weapon_Shortblade_51", "=q3=耳語屠殺之刃", "=ds=#h1#, #w4#", "7.14%" },
        { 27905, "INV_Sword_2H_Blood_C_03", "=q3=恐怖夢境之劍", "=ds=#h3#, #w10#", "4.76%" },
        { 27903, "INV_Spear_08", "=q3=音速之矛", "=ds=#w7#", "7.14%" },
        { 27910, "INV_Shield_36", "=q3=銀月羽飾盾牌", "=ds=#w8#", "5.95%" },
	{ 0,"","","" },
   	{ 31722, "INV_Misc_Orb_05", "=q1=莫爾墨的精華", "=ds=#m3#", "100%" },
        { 30563, "INV_Jewelcrafting_Nightseye_03", "=q4=華麗黝簾石", "=ds=#e7#", "16.67%" },
        { 30559, "INV_Jewelcrafting_NobleTopaz_03", "=q4=蝕刻火焰蛋白石", "=ds=#e7#", "17.85%" },
        { 30560, "INV_Jewelcrafting_Talasite_03", "=q4=符文表面的綠玉髓", "=ds=#e7#", "15.47%" },
        { 24309, "INV_Scroll_05", "=q4=圖樣:法擊短褲", "=ds=#p8# (375)", "0.37%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
	{ 27778, "INV_Shoulder_18", "=q3=遺忘護肩", "=ds=#s3#, #a1# (D3)", "20.24%" },
	{ 28232, "INV_Chest_Cloth_29", "=q3=赦免長袍", "=ds=#s5#, #a1# (D3)", "4.76%" },
	{ 28230, "INV_Chest_Cloth_39", "=q3=神聖服飾", "=ds=#s5#, #a1# (D3)", "7.14%" },
        { 27908, "INV_Pants_Leather_03", "=q3=刺殺護腿", "=ds=#s11#, #a2# (D3)", "5.95%" },
        { 27909, "INV_Pants_Mail_06", "=q3=惡潮褶裙", "=ds=#s11#, #a3# (D3)", "26.19%" },
        { 27803, "INV_Shoulder_26", "=q3=勇猛護肩", "=ds=#s3#, #a4# (D3)", "13.10%" },
        };

    AuchShadowTrash = {
	{ 23607, "INV_Scroll_05", "=q3=設計圖:魔鋼頭盔", "=ds=#p2# (365), =q1=#n56#", "0.61%" },
	};

        ---------------------------------------------
	--- Hellfire Citadel: The Shattered Halls ---
	---------------------------------------------

    HCHallsNethekurse = {
        { 24312, "INV_Scroll_05", "=q4=圖樣:法擊頭環", "=ds=#p8# (375)", "0.47%" },
        { 0,"","","" },
        { 27519, "INV_Misc_Cape_06", "=q3=敵意披風", "=ds=#s4#", "17.44%" },
        { 27517, "INV_Bracer_13", "=q3=奈德克斯手環", "=ds=#s8#, #a1#", "17.52%" },
        { 27521, "INV_Belt_09", "=q3=泰拉蕊狩獵腰帶", "=ds=#s10#, #a3#", "16.50%" },
        { 27520, "INV_Helmet_03", "=q3=堅固頭盔", "=ds=#s1#, #a4#", "16.47%" },
        { 27518, "Spell_Arcane_Arcane03", "=q3=元帥的鎖鏈重靴", "=ds=#s16#, #w14#", "17.42%" },
        { 0,"","","" },
        { 23735, "INV_Jewelry_Amulet_04", "=q1=大術士·奈德克斯的護符", "=ds=#m3#", "13.91%" },
        };

    HCHallsNethekurseHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 24312, "INV_Scroll_05", "=q4=圖樣:法擊頭環", "=ds=#p8# (375)", "0.47%" },
	{ 30548, "INV_Jewelcrafting_Talasite_03", "=q4=拋光的綠玉髓", "=ds=#e7#", "0.16%" },
	{ 30547, "INV_Jewelcrafting_NobleTopaz_03", "=q4=夜光火蛋白石", "=ds=#e7#", "0.19%" },
	{ 30546, "INV_Jewelcrafting_Nightseye_03", "=q4=高貴黝簾石", "=ds=#e7#", "3.39%" },
	{ 0,"","","" },
        { 27519, "INV_Misc_Cape_06", "=q3=敵意披風", "=ds=#s4#", "19.75%" },
        { 27517, "INV_Bracer_13", "=q3=奈德克斯手環", "=ds=#s8#, #a1#", "12.35%" },
        { 27521, "INV_Belt_09", "=q3=泰拉蕊狩獵腰帶", "=ds=#s10#, #a3#", "17.28%" },
        { 27520, "INV_Helmet_03", "=q3=堅固頭盔", "=ds=#s1#, #a4#", "11.11%" },
        { 27518, "Spell_Arcane_Arcane03", "=q3=元帥的鎖鏈重靴", "=ds=#s16#, #w14#", "24.69%" },
        { 0,"","","" },
        { 25462, "INV_Misc_Book_06", "=q1=黑暗之書", "=ds=#m3#", "100%" },
        };
        
    HCHallsOmrogg = {
        { 27525, "INV_Boots_Cloth_12", "=q3=神聖寶石長靴", "=ds=#s12#, #a1#", "18.26%" },
        { 27868, "INV_Weapon_Shortblade_52", "=q3=符歌匕首", "=ds=#h3#, #w4#", "15.32%" },
        { 27524, "INV_Mace_36", "=q3=毀滅火錘", "=ds=#h2#, #w6#", "17.95%" },
        { 27526, "INV_Weapon_Bow_17", "=q3=天火鷹弓", "=ds=#w2#", "17.31%" },
        { 0,"","","" },
        { 30829, "INV_Misc_Gem_Diamond_05", "=q1=大地之母的眼淚", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27802, "INV_Shoulder_31", "=q3=惡潮護肩", "=ds=#s3#, #a3# (D3)", "17.02%" },
        };

    HCHallsOmroggHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30548, "INV_Jewelcrafting_Talasite_03", "=q4=拋光的綠玉髓", "=ds=#e7#", "0.16%" },
	{ 30547, "INV_Jewelcrafting_NobleTopaz_03", "=q4=夜光火蛋白石", "=ds=#e7#", "0.19%" },
	{ 30546, "INV_Jewelcrafting_Nightseye_03", "=q4=高貴黝簾石", "=ds=#e7#", "3.39%" },
	{ 0,"","","" },
        { 27525, "INV_Boots_Cloth_12", "=q3=神聖寶石長靴", "=ds=#s12#, #a1#", "14.29%" },
        { 27868, "INV_Weapon_Shortblade_52", "=q3=符歌匕首", "=ds=#h3#, #w4#", "24.49%" },
        { 27524, "INV_Mace_36", "=q3=毀滅火錘", "=ds=#h2#, #w6#", "18.37%" },
        { 27526, "INV_Weapon_Bow_17", "=q3=天火鷹弓", "=ds=#w2#", "22.45%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27802, "INV_Shoulder_31", "=q3=惡潮護肩", "=ds=#s3#, #a3# (D3)", "8.16%" },
	};
        
    HCHallsKargath = {
        { 27527, "INV_Pants_Plate_01", "=q3=粉碎者護脛", "=ds=#s11#, #a4#", "12.89%" },
        { 27529, "INV_QirajIdol_Rebirth", "=q3=巨大的雕像", "=ds=#s14#", "10.41%" },
        { 27534, "INV_Misc_Gem_LionsEye_01", "=q3=光輝霍特斯印記", "=ds=#s15#", "12.98%" },
        { 27533, "INV_Weapon_Hand_05", "=q3=惡魔之血精華器", "=ds=#h3#, #w13#", "12.70%" },
        { 27538, "INV_Staff_30", "=q3=聖光之誓大錘", "=ds=#h3#, #w6#", "10.6%" },
        { 27540, "INV_Wand_18", "=q3=奈薩斯火把", "=ds=#w12#", "13.02%" },
        { 0,"","","" },
        { 23723, "INV_Weapon_Hand_03", "=q1=大酋長卡喀斯之手", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27536, "INV_Gauntlets_27", "=q3=神聖裹手", "=ds=#s9#, #a1# (D3)", "12.63%" },
        { 27537, "INV_Gauntlets_16", "=q3=赦免手套", "=ds=#s9#, #a1# (D3)", "12.54%" },
        { 27531, "INV_Gauntlets_25", "=q3=荒行手套", "=ds=#s9#, #a2# (D3)", "11.03%" },
        { 27474, "INV_Gauntlets_10", "=q3=野獸領主護手", "=ds=#s9#, #a3# (D3)", "10.73%" },
        { 27528, "INV_Gauntlets_10", "=q3=哀傷之鏈護手", "=ds=#s9#, #a3# (D3)", "13.86%" },
        { 27535, "INV_Gauntlets_29", "=q3=正直護手", "=ds=#s9#, #a4# (D3)", "11.24%" },
        };

    HCHallsKargathHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 29255, "INV_Bracer_13", "=q4=純化魔法指環", "=ds=#s8#, #a1#", "0.58%" },
        { 29263, "INV_Bracer_02", "=q4=森林之心護腕", "=ds=#s8#, #a2#", "0.28%" },
	{ 29348, "INV_Weapon_Hand_10", "=q4=拳刃", "=ds=#h3#, #w13#", "3.39%" },
	{ 0,"","","" },
        { 27527, "INV_Pants_Plate_01", "=q3=粉碎者護脛", "=ds=#s11#, #a4#", "13.56%" },
        { 27529, "INV_QirajIdol_Rebirth", "=q3=巨大的雕像", "=ds=#s14#", "11.86%" },
        { 27534, "INV_Misc_Gem_LionsEye_01", "=q3=光輝霍特斯印記", "=ds=#s15#", "6.78%" },
        { 27533, "INV_Weapon_Hand_05", "=q3=惡魔之血精華器", "=ds=#h3#, #w13#", "6.78%" },
        { 27538, "INV_Staff_30", "=q3=聖光之誓大錘", "=ds=#h3#, #w6#", "16.95%" },
        { 27540, "INV_Wand_18", "=q3=奈薩斯火把", "=ds=#w12#", "22.03%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
	{ 30548, "INV_Jewelcrafting_Talasite_03", "=q4=拋光的綠玉髓", "=ds=#e7#", "0.16%" },
	{ 30547, "INV_Jewelcrafting_NobleTopaz_03", "=q4=夜光火蛋白石", "=ds=#e7#", "0.19%" },
	{ 30546, "INV_Jewelcrafting_Nightseye_03", "=q4=高貴黝簾石", "=ds=#e7#", "3.39%" },
        { 0,"","","" },
        { 0,"","","" },
        { 27536, "INV_Gauntlets_27", "=q3=神聖裹手", "=ds=#s9#, #a1# (D3)", "12.63%" },
        { 27537, "INV_Gauntlets_16", "=q3=赦免手套", "=ds=#s9#, #a1# (D3)", "12.54%" },
        { 27531, "INV_Gauntlets_25", "=q3=荒行手套", "=ds=#s9#, #a2# (D3)", "11.03%" },
        { 27474, "INV_Gauntlets_10", "=q3=野獸領主護手", "=ds=#s9#, #a3# (D3)", "10.73%" },
        { 27528, "INV_Gauntlets_10", "=q3=哀傷之鏈護手", "=ds=#s9#, #a3# (D3)", "13.86%" },
        { 27535, "INV_Gauntlets_29", "=q3=正直護手", "=ds=#s9#, #a4# (D3)", "11.24%" },
        };

    HCHallsPorung = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30548, "INV_Jewelcrafting_Talasite_03", "=q4=拋光的綠玉髓", "=ds=#e7#", "0.16%" },
	{ 30547, "INV_Jewelcrafting_NobleTopaz_03", "=q4=夜光火蛋白石", "=ds=#e7#", "0.19%" },
	{ 30546, "INV_Jewelcrafting_Nightseye_03", "=q4=高貴黝簾石", "=ds=#e7#", "3.39%" },
        { 0,"","","" },
	{ 30709, "INV_Pants_Cloth_14", "=q3=灼熱怒氣馬褲", "=ds=#s11#, #a1#", "14.58%" },
	{ 30707, "INV_Boots_05", "=q3=輕巧足跡長靴", "=ds=#s12#, #a2#", "10.42%" },
	{ 30708, "INV_Belt_03", "=q3=流動思緒腰帶", "=ds=#s10#, #a3#", "12.50%" },
	{ 30705, "INV_Shoulder_26", "=q3=殺戮肩甲", "=ds=#s3#, #a4#", "21.88%" },
	{ 30710, "INV_Jewelry_Necklace_04", "=q3=血衛士的兇殘項鍊", "=ds=#s2#", "10.42%" },
	};

    HCHallsTrash = {
        { 22554, "INV_Misc_Note_01", "=q2=公式:附魔雙手武器 - 野性", "=ds=#p4# (350) =q1=#n88#", "1.65%" },
	};

        ------------------------------------------
	--- Coilfang Reservoir: The Steamvault ---
	------------------------------------------

    CFRSteamThespia = {
        { 27789, "INV_Misc_Cape_16", "=q3=低語貝殼披風", "=ds=#s4#", "14.32%" },
        { 27787, "INV_Chest_Plate11", "=q3=坦然胸甲", "=ds=#s5#, #a2#", "17.65%" },
        { 27783, "INV_Belt_08", "=q3=月怒腰帶", "=ds=#s10#, #a2#", "18.71%" },
        { 27784, "INV_Jewelry_Ring_62", "=q3=火花珊瑚指環", "=ds=#s13#", "16.72%" },
        { 0,"","","" },
        { 29673, "INV_Scroll_06", "=q2=圖樣:寒冰護甲片", "=ds=#p7# (340)", "0.60%" },
        { 0,"","","" },
        { 30828, "INV_Misc_Powder_Black", "=q1=瓶裝地獄土壤", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27508, "INV_Gauntlets_17", "=q3=魔法使的手套", "=ds=#s9#, #a1# (D3)", "17.09%" },
        };

    CFRSteamThespiaHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30550, "INV_Jewelcrafting_Talasite_03", "=q4=碎裂綠玉髓", "=ds=#e7#", "8.59%" },
        { 30551, "INV_Jewelcrafting_NobleTopaz_03", "=q4=注入能量的火焰蛋白石", "=ds=#e7#", "6.64%" },
        { 30549, "INV_Jewelcrafting_Nightseye_03", "=q4=變形的黝簾石", "=ds=#e7#", "1.56%" },
        { 0,"","","" },
        { 27789, "INV_Misc_Cape_16", "=q3=低語貝殼披風", "=ds=#s4#", "18.71%" },
        { 27787, "INV_Chest_Plate11", "=q3=坦然胸甲", "=ds=#s5#, #a2#", "19.35%" },
        { 27783, "INV_Belt_08", "=q3=月怒腰帶", "=ds=#s10#, #a2#", "12.26%" },
        { 27784, "INV_Jewelry_Ring_62", "=q3=火花珊瑚指環", "=ds=#s13#", "17.42%" },
        { 0,"","","" },
        { 29673, "INV_Scroll_06", "=q2=圖樣:寒冰護甲片", "=ds=#p7# (340)", "0.60%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27508, "INV_Gauntlets_17", "=q3=魔法使的手套", "=ds=#s9#, #a1# (D3)", "14.19%" },
	};

    CFRSteamSteamrigger = {
        { 27793, "INV_Gauntlets_03", "=q3=大地披風裹手", "=ds=#s9#, #a3#", "16.92%" },
        { 27790, "INV_Helmet_74", "=q3=苦行面罩", "=ds=#s1#, #a4#", "16.65%" },
        { 27792, "Ability_Rogue_NervesOfSteel", "=q3=勇氣蒸汽絞鏈圈", "=ds=#s2#", "14.49%" },
        { 27791, "INV_Staff_48", "=q3=蛇峰生命法杖", "=ds=#w9#", "17.09%" },
        { 27794, "INV_Weapon_Rifle_19", "=q3=X-54型無後座力火箭撕裂炮", "=ds=#w5#", "15.88%" },
	{ 0,"","","" },
	{ 23887, "INV_Scroll_05", "=q3=結構圖:火箭靴極限版", "=ds=#p5# (355)", "0.52%" },
        };

    CFRSteamSteamriggerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30550, "INV_Jewelcrafting_Talasite_03", "=q4=碎裂綠玉髓", "=ds=#e7#", "8.59%" },
        { 30551, "INV_Jewelcrafting_NobleTopaz_03", "=q4=注入能量的火焰蛋白石", "=ds=#e7#", "6.64%" },
        { 30549, "INV_Jewelcrafting_Nightseye_03", "=q4=變形的黝簾石", "=ds=#e7#", "1.56%" },
	{ 0,"","","" },
        { 27793, "INV_Gauntlets_03", "=q3=大地披風裹手", "=ds=#s9#, #a3#", "17.83%" },
        { 27790, "INV_Helmet_74", "=q3=苦行面罩", "=ds=#s1#, #a4#", "17.05%" },
        { 27792, "Ability_Rogue_NervesOfSteel", "=q3=勇氣蒸汽絞鏈圈", "=ds=#s2#", "14.73%" },
        { 27791, "INV_Staff_48", "=q3=蛇峰生命法杖", "=ds=#w9#", "7.75%" },
        { 27794, "INV_Weapon_Rifle_19", "=q3=X-54型無後座力火箭撕裂炮", "=ds=#w5#", "17.83%" },
	{ 0,"","","" },
	{ 23887, "INV_Scroll_05", "=q3=結構圖:火箭靴極限版", "=ds=#p5# (355)", "0.52%" },
	};

    CFRSteamWarlord = {
        { 24313, "INV_Scroll_05", "=q4=圖樣:戰放頭環", "=ds=#p8# (375)", "0.20%" },
        { 0,"","","" },
        { 27804, "INV_Misc_Cape_13", "=q3=惡魔鯊魚斗篷", "=ds=#s4#", "12.18%" },
        { 27799, "INV_Chest_Cloth_18", "=q3=朱紅支配長袍", "=ds=#s5#, #a1#", "12.47%" },
        { 27795, "INV_Belt_13", "=q3=巨蛇腰帶", "=ds=#s10#, #a1#", "11.03%" },
        { 27806, "INV_Gauntlets_10", "=q3=深淵之心護手", "=ds=#s9#, #a3#", "14.84%" },
        { 27805, "INV_Jewelry_Ring_66", "=q3=銀手之戒", "=ds=#s13#", "13.95%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27738, "INV_Shoulder_02", "=q3=魔法使的護肩", "=ds=#s3#, #a1# (D3)", "12.25%" },
        { 27737, "INV_Shoulder_24", "=q3=月林護肩", "=ds=#s3#, #a2# (D3)", "12.89%" },
        { 27801, "INV_Shoulder_23", "=q3=野獸領主襯肩", "=ds=#s3#, #a3# (D3)", "10.63%" },
        { 27510, "INV_Gauntlets_10", "=q3=惡潮護手", "=ds=#s9#, #a3# (D3)", "12.45%" },
        { 27874, "INV_Pants_03", "=q3=野獸領主護腿", "=ds=#s11#, #a3# (D3)", "9.56%" },
        { 28203, "INV_Chest_Chain_15", "=q3=公正胸甲", "=ds=#s5#, #a4# (D3)", "10.98%" },
        { 27475, "INV_Gauntlets_28", "=q3=勇猛護手", "=ds=#s9#, #a4# (D3)", "10.05%" },
        };

    CFRSteamWarlordHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30543, "INV_Pants_Cloth_20", "=q4=教皇褶裙", "=ds=#s11#, #a1#", "7.81%" },
        { 29243, "INV_Bracer_02", "=q4=怒浪臂鎧", "=ds=#s8#, #a3#", "17.97%" },
        { 29463, "INV_Bracer_02", "=q4=侵略者的琥珀指環", "=ds=#s8#, #a4#", "2.34%" },
        { 29351, "INV_Weapon_Crossbow_16", "=q4=怒潮長弓", "=ds=#w2#", "3.52%" },
        { 0,"","","" },
        { 27804, "INV_Misc_Cape_13", "=q3=惡魔鯊魚斗篷", "=ds=#s4#", "15.23%" },
        { 27799, "INV_Chest_Cloth_18", "=q3=朱紅支配長袍", "=ds=#s5#, #a1#", "8.59%" },
        { 27795, "INV_Belt_13", "=q3=巨蛇腰帶", "=ds=#s10#, #a1#", "15.62%" },
        { 27806, "INV_Gauntlets_10", "=q3=深淵之心護手", "=ds=#s9#, #a3#", "13.28%" },
        { 27805, "INV_Jewelry_Ring_66", "=q3=銀手之戒", "=ds=#s13#", "8.98%" },
        { 0,"","","" },
        { 31721, "INV_Misc_Shovel_02", "=q1=卡利斯瑞的三叉戟", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 24313, "INV_Scroll_05", "=q4=圖樣:戰放頭環", "=ds=#p8# (375)", "0.20%" },
        { 30550, "INV_Jewelcrafting_Talasite_03", "=q4=碎裂綠玉髓", "=ds=#e7#", "8.59%" },
        { 30551, "INV_Jewelcrafting_NobleTopaz_03", "=q4=注入能量的火焰蛋白石", "=ds=#e7#", "6.64%" },
        { 30549, "INV_Jewelcrafting_Nightseye_03", "=q4=變形的黝簾石", "=ds=#e7#", "1.56%" },
        { 0,"","","" },
        { 0,"","","" },
        { 27738, "INV_Shoulder_02", "=q3=魔法使的護肩", "=ds=#s3#, #a1# (D3)", "10.94%" },
        { 27737, "INV_Shoulder_24", "=q3=月林護肩", "=ds=#s3#, #a2# (D3)", "7.03%" },
        { 27801, "INV_Shoulder_23", "=q3=野獸領主襯肩", "=ds=#s3#, #a3# (D3)", "8.59%" },
        { 27510, "INV_Gauntlets_10", "=q3=惡潮護手", "=ds=#s9#, #a3# (D3)", "11.72%" },
        { 27874, "INV_Pants_03", "=q3=野獸領主護腿", "=ds=#s11#, #a3# (D3)", "6.64%" },
        { 28203, "INV_Chest_Chain_15", "=q3=公正胸甲", "=ds=#s5#, #a4# (D3)", "13.28%" },
        { 27475, "INV_Gauntlets_28", "=q3=勇猛護手", "=ds=#s9#, #a4# (D3)", "7.81%" },
	};

    CFRSteamTrash = {
        { 24159, "INV_Scroll_05", "=q3=設計圖:冰霜可利安指環", "=ds=#p12# (355) =q1=#n86#", "0.14%" },
        { 0,"","","" },
        { 22533, "INV_Misc_Note_01", "=q2=公式:附魔護腕 - 堅韌", "=ds=#p4# (350) =q1=#n87#", "0.40%" },
        { 0,"","","" },
        { 24367, "INV_Misc_Note_06", "=q1=瓦許女士的命令", "=ds=#m2#" },
        { 24368, "INV_Spear_06", "=q1=盤牙裝備", "=ds=#m3#", "12.68%" },
	};

        -----------------------------------------
	--- Caverns of Time: The Black Morass ---
	-----------------------------------------

    CoTMorassDeja = {
        { 27988, "INV_Misc_Cape_15", "=q3=時間轉移斗篷", "=ds=#s4#", "13.87%" },
        { 27994, "INV_Shoulder_36", "=q3=三大恐懼襯肩", "=ds=#s3#, #a1#", "12.30%" },
        { 27995, "INV_Shoulder_08", "=q3=鍍陽護肩", "=ds=#s3#, #a2#", "13.13%" },
        { 27993, "INV_Helmet_17", "=q3=心靈之火面罩", "=ds=#s1#, #a3#", "13.84%" },
        { 27996, "INV_Jewelry_Ring_59", "=q3=心靈專注之戒", "=ds=#s13#", "14.45%" },
        { 27987, "INV_Weapon_Bow_19", "=q3=梅爾摩塔之微光長弓", "=ds=#w2#", "11.51%" },
        { 0,"","","" },
        { 29675, "INV_Scroll_06", "=q2=圖樣:祕法護甲片", "=ds=#p7# (340)", "0.35%" },
        };

    CoTMorassDejaHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30558, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃光火焰蛋白石", "=ds=#e7#" },
        { 30556, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃爍的火焰蛋白石", "=ds=#e7#" },
        { 30555, "INV_Jewelcrafting_Nightseye_03", "=q4=發光的黝簾石", "=ds=#e7#" },
        { 0,"","","" },
        { 27988, "INV_Misc_Cape_15", "=q3=時間轉移斗篷", "=ds=#s4#", "14.29%" },
        { 27994, "INV_Shoulder_36", "=q3=三大恐懼襯肩", "=ds=#s3#, #a1#", "12.86%" },
        { 27995, "INV_Shoulder_08", "=q3=鍍陽護肩", "=ds=#s3#, #a2#", "21.43%" },
        { 27993, "INV_Helmet_17", "=q3=心靈之火面罩", "=ds=#s1#, #a3#", "11.43%" },
	{ 27996, "INV_Jewelry_Ring_59", "=q3=心靈專注之戒", "=ds=#s13#", "7.14%" },
        { 27987, "INV_Weapon_Bow_19", "=q3=梅爾摩塔之微光長弓", "=ds=#w2#", "11.43%" },
        { 0,"","","" },
        { 29675, "INV_Scroll_06", "=q2=圖樣:祕法護甲片", "=ds=#p7# (340)", "0.35%" },
	};

    CoTMorassTemporus = {
        { 28185, "INV_Pants_Leather_05", "=q3=誓絕之卡德加褶裙", "=ds=#s11#, #a1#", "14.26%" },
        { 28186, "INV_Chest_Leather_04", "=q3=訕笑骷髏戰爭背心", "=ds=#s5#, #a3#", "13.14%" },
        { 28034, "INV_Gizmo_KhoriumPowerCore", "=q3=破壞者沙漏", "=ds=#s14#", "13.69%" },
        { 28187, "INV_Offhand_OutlandRaid_03blue", "=q3=星心照明燈", "=ds=#s15#", "11.83%" },
        { 28184, "INV_Sword_64", "=q3=千禧之刃", "=ds=#h1#, #w10#", "11.74%" },
        { 28033, "INV_Staff_46", "=q3=新紀元修補權杖", "=ds=#w9#", "13.80%" },
        };

    CoTMorassTemporusHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30558, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃光火焰蛋白石", "=ds=#e7#" },
        { 30556, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃爍的火焰蛋白石", "=ds=#e7#" },
        { 30555, "INV_Jewelcrafting_Nightseye_03", "=q4=發光的黝簾石", "=ds=#e7#" },
        { 0,"","","" },
        { 28185, "INV_Pants_Leather_05", "=q3=誓絕之卡德加褶裙", "=ds=#s11#, #a1#", "12.77%" },
        { 28186, "INV_Chest_Leather_04", "=q3=訕笑骷髏戰爭背心", "=ds=#s5#, #a3#", "14.89%" },
        { 28034, "INV_Gizmo_KhoriumPowerCore", "=q3=破壞者沙漏", "=ds=#s14#", "8.51%" },
        { 28187, "INV_Offhand_OutlandRaid_03blue", "=q3=星心照明燈", "=ds=#s15#", "8.51%" },
        { 28184, "INV_Sword_64", "=q3=千禧之刃", "=ds=#h1#, #w10#", "25.53%" },
        { 28033, "INV_Staff_46", "=q3=新紀元修補權杖", "=ds=#w9#", "12.77%" },
        };

    CoTMorassAeonus = {
        { 28206, "INV_Helmet_29", "=q3=無罪兜帽", "=ds=#s1#, #a2#", "12.25%" },
        { 28194, "INV_Bracer_12", "=q3=原浪護腕", "=ds=#s8#, #a3#", "13.51%" },
        { 28207, "INV_Shoulder_01", "=q3=血紅飛行肩甲", "=ds=#s3#, #a4#", "11.11%" },
        { 28190, "INV_Misc_AhnQirajTrinket_06", "=q3=無盡迴圈寶石", "=ds=#s14#", "11.32%" },
        { 28189, "INV_Sword_76", "=q3=拉托的移型長劍", "=ds=#h1#, #w10#", "9.70%" },
        { 28188, "INV_Staff_40", "=q3=血火大法杖", "=ds=#w9#", "10.48%" },
        { 0,"","","" },
        { 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
        { 28193, "INV_Jewelry_Ring_56", "=q3=法力蝕刻頭冠", "=ds=#s1#, #a1# (D3)", "11.99%" },
        { 27509, "INV_Gauntlets_01", "=q3=刺客手套", "=ds=#s9#, #a2# (D3)", "12.84%" },
        { 27873, "INV_Pants_14", "=q3=月林長褲", "=ds=#s11#, #a2# (D3)", "11.28%" },
        { 28192, "INV_Helmet_18", "=q3=哀傷之鏈頭盔", "=ds=#s1#, #a3# (D3)", "12.77%" },
        { 27977, "INV_Pants_Plate_06", "=q3=勇猛腿甲", "=ds=#s11#, #a4# (D3)", "9.92%" },
        { 27839, "INV_Pants_04", "=q3=正義腿甲", "=ds=#s11#, #a4# (D3)", "12.10%" },
        };

    CoTMorassAeonusHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30531, "INV_Pants_Mail_20", "=q4=神秘長褲", "=ds=#s11#, #a1#", "1.49%" },
        { 29247, "INV_Belt_26", "=q4=死靈腰帶", "=ds=#s10#, #a2#" },
	{ 29253, "INV_Belt_11", "=q4=英勇功蹟腰帶", "=ds=#s10#, #a4#" },
        { 29356, "INV_Sword_81", "=q4=量子劍", "=ds=#h2#, #w10#" },
	{ 0,"","","" },
        { 28206, "INV_Helmet_29", "=q3=無罪兜帽", "=ds=#s1#, #a2#", "17.91%" },
        { 28194, "INV_Bracer_12", "=q3=原浪護腕", "=ds=#s8#, #a3#", "7.46%" },
        { 28207, "INV_Shoulder_01", "=q3=血紅飛行肩甲", "=ds=#s3#, #a4#", "11.94%" },
        { 28190, "INV_Misc_AhnQirajTrinket_06", "=q3=無盡迴圈寶石", "=ds=#s14#", "14.93%" },
        { 28189, "INV_Sword_76", "=q3=拉托的移型長劍", "=ds=#h1#, #w10#", "5.97%" },
        { 28188, "INV_Staff_40", "=q3=血火大法杖", "=ds=#w9#", "20.90%" },
	{ 0,"","","" },
        { 0,"","","" },
	{ 0,"","","" },
        { 30558, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃光火焰蛋白石", "=ds=#e7#" },
        { 30556, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃爍的火焰蛋白石", "=ds=#e7#" },
        { 30555, "INV_Jewelcrafting_Nightseye_03", "=q4=發光的黝簾石", "=ds=#e7#" },
	{ 0,"","","" },
        { 0,"","","" },
	{ 0,"","","" },
        { 28193, "INV_Jewelry_Ring_56", "=q3=法力蝕刻頭冠", "=ds=#s1#, #a1# (D3)", "7.46%" },
        { 27509, "INV_Gauntlets_01", "=q3=刺客手套", "=ds=#s9#, #a2# (D3)", "5.97%" },
        { 27873, "INV_Pants_14", "=q3=月林長褲", "=ds=#s11#, #a2# (D3)", "16.42%" },
        { 28192, "INV_Helmet_18", "=q3=哀傷之鏈頭盔", "=ds=#s1#, #a3# (D3)", "19.40%" },
        { 27977, "INV_Pants_Plate_06", "=q3=勇猛腿甲", "=ds=#s11#, #a4# (D3)", "8.96%" },
        { 27839, "INV_Pants_04", "=q3=正義腿甲", "=ds=#s11#, #a4# (D3)", "7.46%" },
	};

    CoTMorassTrash = {
	{ 25730, "INV_Scroll_05", "=q3=圖樣:造型森林帽", "=ds=#p7# (350) =q1=#n95#", "0.29%" },
	};

        ----------------------------------
	--- Tempest Keep: The Mechanar ---
	----------------------------------

    TKMechGyro = {
        { 30436, "INV_Misc_Gem_AzureDraenite_03", "=q1=藍色鋸齒水晶", "=ds=#e9#", "100%" },
        };

    TKMechGyroHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 0,"","","" },
        { 30436, "INV_Misc_Gem_AzureDraenite_03", "=q1=藍色鋸齒水晶", "=ds=#e9#", "100%" },
	};

    TKMechIron = {
        { 30437, "INV_Misc_Gem_BloodGem_03", "=q1=紅色鋸齒水晶", "=ds=#e9#", "100%" },
        };

    TKMechIronHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 0,"","","" },
        { 30437, "INV_Misc_Gem_BloodGem_03", "=q1=紅色鋸齒水晶", "=ds=#e9#", "100%" },
	};

    TKMechCacheoftheLegion = {
        { 28249, "INV_Misc_Cape_20", "=q3=卡帕希特斯的測定披風", "=ds=#s4#", "21.16%" },
        { 28250, "INV_Shoulder_35", "=q3=維斯提亞之精神恩典護肩", "=ds=#s3#, #a1#", "17.89%" },
        { 28252, "INV_Chest_Cloth_25", "=q3=殲滅血長袍", "=ds=#s5#, #a1#", "22.53%" },
        { 28251, "INV_Boots_05", "=q3=持劍者長靴", "=ds=#s12#, #a2#", "18.74%" },
        { 28248, "Spell_Arcane_Blast", "=q3=虛空圖騰", "=ds=#s16#, #w15#", "19.58%" },
	};

    TKMechCapacitus = {
        { 28256, "INV_Misc_Cape_11", "=q3=瑟銀編織披風", "=ds=#s4#", "14.81%" },
        { 28255, "INV_Shoulder_19", "=q3=月爪肩甲", "=ds=#s3#, #a2#", "16.98%" },
        { 28254, "INV_Jewelry_Necklace_30Naxxramas", "=q3=扭曲工程師之多彩項鍊", "=ds=#s2#", "16.81%" },
        { 28257, "INV_Mace_13", "=q3=懺悔之錘", "=ds=#h3#, #w6#", "14.36%" },
        { 28253, "INV_Weapon_Halberd15", "=q3=漿鼠超長鐮刀", "=ds=#w7#", "17.69%" },
        };

    TKMechCapacitusHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30565, "INV_Jewelcrafting_NobleTopaz_03", "=q4=刺客的火焰蛋白石", "=ds=#e7#", "18.72%" },
        { 30566, "INV_Jewelcrafting_Nightseye_03", "=q4=防禦者的黝簾石", "=ds=#e7#", "8.87%" },
        { 30564, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃亮火焰蛋白石", "=ds=#e7#", "3.45%" },
        { 0,"","","" },
        { 28256, "INV_Misc_Cape_11", "=q3=瑟銀編織披風", "=ds=#s4#", "11.95%" },
        { 28255, "INV_Shoulder_19", "=q3=月爪肩甲", "=ds=#s3#, #a2#", "17.13%" },
        { 28254, "INV_Jewelry_Necklace_30Naxxramas", "=q3=扭曲工程師之多彩項鍊", "=ds=#s2#", "18.33%" },
        { 28257, "INV_Mace_13", "=q3=懺悔之錘", "=ds=#h3#, #w6#", "11.95%" },
        { 28253, "INV_Weapon_Halberd15", "=q3=漿鼠超長鐮刀", "=ds=#w7#", "19.12%" },
        };

    TKMechSepethrea = {
        { 28262, "INV_Chest_Plate07", "=q3=玉顱胸甲", "=ds=#s5#, #a4#", "15.37%" },
        { 28259, "INV_Jewelry_Ring_62", "=q3=宇宙生命之戒", "=ds=#s13#", "18.06%" },
        { 28260, "INV_Misc_Book_05", "=q3=地獄法師寶典", "=ds=#s15#", "15.61%" },
        { 28263, "INV_Axe_63", "=q3=星斧", "=ds=#h1#, #w1#", "15.58%" },
        { 28258, "INV_Misc_Coin_10", "=q3=地獄飛鏢", "=ds=#w11#", "15.88%" },
        };

    TKMechSepethreaHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 30565, "INV_Jewelcrafting_NobleTopaz_03", "=q4=刺客的火焰蛋白石", "=ds=#e7#", "18.72%" },
        { 30566, "INV_Jewelcrafting_Nightseye_03", "=q4=防禦者的黝簾石", "=ds=#e7#", "8.87%" },
        { 30564, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃亮火焰蛋白石", "=ds=#e7#", "3.45%" },
        { 0,"","","" },
        { 28262, "INV_Chest_Plate07", "=q3=玉顱胸甲", "=ds=#s5#, #a4#", "14.63%" },
        { 28259, "INV_Jewelry_Ring_62", "=q3=宇宙生命之戒", "=ds=#s13#", "26.22%" },
        { 28260, "INV_Misc_Book_05", "=q3=地獄法師寶典", "=ds=#s15#", "25.61%" },
        { 28263, "INV_Axe_63", "=q3=星斧", "=ds=#h1#, #w1#", "9.15%" },
        { 28258, "INV_Misc_Coin_10", "=q3=地獄飛鏢", "=ds=#w11#", "14.63%" },
        };

    TKMechCalc = {
        { 28269, "INV_Misc_Cape_05", "=q3=巴巴的祕法披風", "=ds=#s4#", "11.78%" },
        { 28266, "INV_Pants_Plate_02", "=q3=熔岩大地褶裙", "=ds=#s11#, #a3#", "12.26%" },
        { 28265, "INV_Jewelry_Ring_50Naxxramas", "=q3=達斯雷瑪防禦之戒", "=ds=#s13#", "10.61%" },
        { 28288, "INV_Misc_EngGizmos_18", "=q3=暴力機會算盤", "=ds=#s14#", "10.54%" },
        { 27899, "INV_Sword_draenei_04", "=q3=神力之怒", "=ds=#h3#, #w10#", "11.38%" },
        { 28267, "INV_Sword_77", "=q3=宇宙之劍", "=ds=#h1#, #w10#", "11.13%" },
        { 28286, "INV_Weapon_Rifle_22", "=q3=望遠鏡刺耳火槍", "=ds=#w5#", "12.28%" },
        { 0,"","","" },
        { 21907, "INV_Scroll_06", "=q2=圖樣:奧紋長袍", "=ds=#p8# (370)", "1.11%" },
        { 0,"","","" },
        { 31086, "INV_Misc_Gem_BloodGem_01", "=q1=亞克崔茲鑰匙的底部碎片", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28278, "INV_Helmet_34", "=q3=魔法使的兜帽", "=ds=#s1#, #a1# (D3)", "13.39%" },
        { 28202, "INV_Chest_Cloth_07", "=q3=月林長袍", "=ds=#s5#, #a2# (D3)", "11.92%" },
        { 28204, "INV_Chest_Chain_17", "=q3=暗殺外衣", "=ds=#s5#, #a2# (D3)", "12.44%" },
        { 28275, "INV_Helmet_19", "=q3=野獸領主頭盔", "=ds=#s1#, #a3# (D3)", "12.37%" },
        { 28285, "INV_Helmet_25", "=q3=正義頭盔", "=ds=#s1#, #a4# (D3)", "10.88%" },
        };

    TKMechCalcHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 29251, "INV_Boots_Cloth_03", "=q4=虔誠長靴", "=ds=#s12#, #a1#", "7.88%" },
        { 32076, "Inv_Gauntlets_31", "=q4=堅定護手", "=ds=#s9#, #a3#" },
	{ 30533, "INV_Pants_Plate_21", "=q4=征服者腿鎧", "=ds=#s11#, #a4#", "6.90%" },
	{ 29362, "INV_Sword_63", "=q4=食日者", "=ds=#h1#, #w10#", "1.48%" },
        { 0,"","","" },
        { 28269, "INV_Misc_Cape_05", "=q3=巴巴的祕法披風", "=ds=#s4#", "11.82%" },
        { 28266, "INV_Pants_Plate_02", "=q3=熔岩大地褶裙", "=ds=#s11#, #a3#", "14.29%" },
        { 28265, "INV_Jewelry_Ring_50Naxxramas", "=q3=達斯雷瑪防禦之戒", "=ds=#s13#", "8.87%" },
        { 28288, "INV_Misc_EngGizmos_18", "=q3=暴力機會算盤", "=ds=#s14#", "8.37%" },
        { 27899, "INV_Sword_draenei_04", "=q3=神力之怒", "=ds=#h3#, #w10#", "9.36%" },
        { 28267, "INV_Sword_77", "=q3=宇宙之劍", "=ds=#h1#, #w10#", "11.82%" },
        { 28286, "INV_Weapon_Rifle_22", "=q3=望遠鏡刺耳火槍", "=ds=#w5#", "9.85%" },
        { 0,"","","" },
        { 21907, "INV_Scroll_06", "=q2=圖樣:奧紋長袍", "=ds=#p8# (370)", "1.11%" },
        { 30565, "INV_Jewelcrafting_NobleTopaz_03", "=q4=刺客的火焰蛋白石", "=ds=#e7#", "18.72%" },
        { 30566, "INV_Jewelcrafting_Nightseye_03", "=q4=防禦者的黝簾石", "=ds=#e7#", "8.87%" },
        { 30564, "INV_Jewelcrafting_NobleTopaz_03", "=q4=閃亮火焰蛋白石", "=ds=#e7#", "3.45%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28278, "INV_Helmet_34", "=q3=魔法使的兜帽", "=ds=#s1#, #a1# (D3)", "14.29%" },
        { 28202, "INV_Chest_Cloth_07", "=q3=月林長袍", "=ds=#s5#, #a2# (D3)", "11.33%" },
        { 28204, "INV_Chest_Chain_17", "=q3=暗殺外衣", "=ds=#s5#, #a2# (D3)", "8.87%" },
        { 28275, "INV_Helmet_19", "=q3=野獸領主頭盔", "=ds=#s1#, #a3# (D3)", "14.78%" },
        { 28285, "INV_Helmet_25", "=q3=正義頭盔", "=ds=#s1#, #a4# (D3)", "10.34%" },
	};
 
    TKMechTrash = {
	{ 22920, "INV_Scroll_06", "=q2=配方:極強效火焰防護藥水", "=ds=#p1# (360) =q1=#n93#", "0.30%" },
	{ 21906, "INV_Scroll_06", "=q2=圖樣:奧紋長靴", "=ds=#p8# (360) =q1=#n93#", "0.57%" },
	};

        ----------------------------------
	--- Tempest Keep: The Botanica ---
	----------------------------------
	
    TKBotSarannis = {
        { 28301, "INV_Misc_Cape_Naxxramas_01", "=q3=薩瑞尼斯謎樣的華服", "=ds=#s4#", "28.54%" },
        { 28304, "INV_Gauntlets_16", "=q3=修補棱石手套", "=ds=#s9#, #a1#", "32.46%" },
        { 28306, "INV_Shoulder_11", "=q3=狩獵卓越襯肩", "=ds=#s3#, #a3#", "30.68%" },
        { 28296, "INV_Misc_Book_12", "=q3=光明使者聖契", "=ds=#s16#, #w16#", "34.10%" },
        { 28311, "INV_Sword_79", "=q3=復仇者", "=ds=#h1#, #w10#", "26.25%" },
        { 0,"","","" },
        { 28769, "INV_Misc_Rune_12", "=q1=拱心石", "=ds=#m3#", "100%" },
        };

    TKBotSarannisHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=野獸黝簾石", "=ds=#e7#", "8.00%" },
	{ 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=帝國黝簾石", "=ds=#e7#", "8.00%" },
	{ 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=神秘火焰蛋白石", "=ds=#e7#", "8.00%" },
        { 0,"","","" },
        { 28301, "INV_Misc_Cape_Naxxramas_01", "=q3=薩瑞尼斯謎樣的華服", "=ds=#s4#", "19.35%" },
        { 28304, "INV_Gauntlets_16", "=q3=修補棱石手套", "=ds=#s9#, #a1#", "38.71%" },
        { 28306, "INV_Shoulder_11", "=q3=狩獵卓越襯肩", "=ds=#s3#, #a3#", "48.39%" },
        { 28296, "INV_Misc_Book_12", "=q3=光明使者聖契", "=ds=#s16#, #w16#", "38.71%" },
        { 28311, "INV_Sword_79", "=q3=復仇者", "=ds=#h1#, #w10#", "16.13%" },
        };

    TKBotFreywinn = {
        { 28317, "INV_Gauntlets_19", "=q3=能量護手", "=ds=#s9#, #a1#", "17.60%" },
        { 28318, "INV_Boots_Plate_06", "=q3=黑曜石無情踐踏者", "=ds=#s12#, #a4#", "16.48%" },
        { 28321, "INV_jewelry_ring_AhnQiraj_01", "=q3=魔化瑟銀項鍊", "=ds=#s2#", "18.09%" },
        { 28315, "INV_Weapon_Hand_08", "=q3=風暴搶奪戰刃", "=ds=#h4#, #w13#", "16.75%" },
        { 28316, "INV_Shield_35", "=q3=太陽鳥之盾", "=ds=#w8#", "14.60%" },
        { 0,"","","" },
        { 23617, "INV_Scroll_05", "=q3=設計圖:大地和平胸甲", "=ds=#p2# (370)", "1.07%" },
        };

    TKBotFreywinnHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=野獸黝簾石", "=ds=#e7#", "8.00%" },
	{ 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=帝國黝簾石", "=ds=#e7#", "8.00%" },
	{ 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=神秘火焰蛋白石", "=ds=#e7#", "8.00%" },
        { 0,"","","" },
        { 28317, "INV_Gauntlets_19", "=q3=能量護手", "=ds=#s9#, #a1#", "3.70%" },
        { 28318, "INV_Boots_Plate_06", "=q3=黑曜石無情踐踏者", "=ds=#s12#, #a4#", "22.22%" },
        { 28321, "INV_jewelry_ring_AhnQiraj_01", "=q3=魔化瑟銀項鍊", "=ds=#s2#", "18.52%" },
        { 28315, "INV_Weapon_Hand_08", "=q3=風暴搶奪戰刃", "=ds=#h4#, #w13#", "29.63%" },
        { 28316, "INV_Shield_35", "=q3=太陽鳥之盾", "=ds=#w8#", "22.22%" },
        { 0,"","","" },
        { 23617, "INV_Scroll_05", "=q3=設計圖:大地和平胸甲", "=ds=#p2# (370)", "1.07%" },
        };

    TKBotThorngrin = {
        { 24310, "INV_Scroll_05", "=q4=圖樣:戰放護腿", "=ds=#p8# (375)", "0.44%" },
        { 0,"","","" },
        { 28324, "INV_Gauntlets_26", "=q3=殘酷意念護手", "=ds=#s9#, #a4#", "15.56%" },
        { 28327, "INV_Jewelry_Ring_62", "=q3=祕法地獄指環", "=ds=#s13#", "17.77%" },
        { 28323, "INV_Jewelry_Ring_16", "=q3=陰影厄運之戒", "=ds=#s13#", "16.25%" },
        { 28322, "INV_Weapon_Shortblade_52", "=q3=符文撫慰匕首", "=ds=#h3#, #w4#", "18.16%" },
        { 28325, "INV_Staff_49", "=q3=睡夢龍杖", "=ds=#w9#", "15.46%" },
        };

    TKBotThorngrinHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=野獸黝簾石", "=ds=#e7#", "8.00%" },
	{ 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=帝國黝簾石", "=ds=#e7#", "8.00%" },
	{ 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=神秘火焰蛋白石", "=ds=#e7#", "8.00%" },
        { 24310, "INV_Scroll_05", "=q4=圖樣:戰放護腿", "=ds=#p8# (375)", "0.44%" },
        { 0,"","","" },
        { 28324, "INV_Gauntlets_26", "=q3=殘酷意念護手", "=ds=#s9#, #a4#", "25.00%" },
        { 28327, "INV_Jewelry_Ring_62", "=q3=祕法地獄指環", "=ds=#s13#", "12.50%" },
        { 28323, "INV_Jewelry_Ring_16", "=q3=陰影厄運之戒", "=ds=#s13#", "16.25%" },
        { 28322, "INV_Weapon_Shortblade_52", "=q3=符文撫慰匕首", "=ds=#h3#, #w4#", "41.67%" },
        { 28325, "INV_Staff_49", "=q3=睡夢龍杖", "=ds=#w9#", "16.67%" },
        };

    TKBotLaj = {
        { 28328, "INV_Misc_Cape_09", "=q3=深綠祕銀披風", "=ds=#s4#", "20.88%" },
        { 28338, "INV_Pants_Cloth_14", "=q3=惡魔縫製護腿", "=ds=#s11#, #a1#", "18.71%" },
        { 28340, "INV_Shoulder_18", "=q3=秋天襯肩", "=ds=#s3#, #a2#", "17.19%" },
        { 28339, "INV_Boots_05", "=q3=流沙長靴", "=ds=#s12#, #a2#", "19.07%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27739, "INV_Shoulder_10", "=q3=正直肩甲", "=ds=#s3#, #a4# (D3)", "18.13%" },
        };

    TKBotLajHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=野獸黝簾石", "=ds=#e7#", "8.00%" },
	{ 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=帝國黝簾石", "=ds=#e7#", "8.00%" },
	{ 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=神秘火焰蛋白石", "=ds=#e7#", "8.00%" },
        { 0,"","","" },
        { 28328, "INV_Misc_Cape_09", "=q3=深綠祕銀披風", "=ds=#s4#", "25.00%" },
        { 28338, "INV_Pants_Cloth_14", "=q3=惡魔縫製護腿", "=ds=#s11#, #a1#", "20.00%" },
        { 28340, "INV_Shoulder_18", "=q3=秋天襯肩", "=ds=#s3#, #a2#", "40.00%" },
        { 28339, "INV_Boots_05", "=q3=流沙長靴", "=ds=#s12#, #a2#", "15.00%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 27739, "INV_Shoulder_10", "=q3=正直肩甲", "=ds=#s3#, #a4# (D3)", "18.13%" },
        };

    TKBotSplinter = {
        { 24311, "INV_Scroll_05", "=q4=圖樣:白癒兜帽", "=ds=#p8# (375)", "0.30%" },
        { 0,"","","" },
        { 28371, "INV_Misc_Cape_02", "=q3=地獄之怒披風", "=ds=#s4#", "13.52%" },
        { 28342, "INV_Chest_Cloth_29", "=q3=扭曲能量外套", "=ds=#s5#, #a1#", "10.27%" },
        { 28347, "INV_Pants_Mail_21", "=q3=扭曲鱗片護腿", "=ds=#s11#, #a2#", "11.74%" },
        { 28343, "INV_Jewelry_Necklace_17", "=q3=鋸齒青褐墜飾", "=ds=#s2#", "12.34%" },
        { 28370, "INV_Jewelry_Necklace_27", "=q3=無盡祝福手鐲", "=ds=#s14#", "12.38%" },
        { 28345, "INV_Weapon_Shortblade_57", "=q3=扭曲分裂者之刺", "=ds=#h1#, #w4#", "10.37%" },
        { 28367, "INV_Sword_58", "=q3=遺棄者幻影之劍", "=ds=#h2#, #w10#", "11.64%" },
        { 28341, "INV_Staff_47", "=q3=秘法之扭曲法杖", "=ds=#w9#", "10.47%" },
	{ 0,"","","" },
        { 31085, "INV_Misc_Gem_AzureDraenite_01", "=q1=亞克崔茲鑰匙的頂部碎片", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28229, "INV_Chest_Cloth_25", "=q3=魔法使的長袍", "=ds=#s5#, #a1# (D3)", "8.42%" },
        { 28348, "INV_Helmet_15", "=q3=月林斗篷", "=ds=#s1#, #a2# (D3)", "11.17%" },
        { 28349, "INV_Helmet_19", "=q3=惡潮頭盔", "=ds=#s1#, #a3# (D3)", "13.85%" },
        { 28228, "INV_Chest_Chain_03", "=q3=野獸領主胸甲", "=ds=#s5#, #a3# (D3)", "9.59%" },
        { 28350, "INV_Helmet_20", "=q3=勇猛頭盔", "=ds=#s1#, #a4# (D3)", "8.96%" },
        };

    TKBotSplinterHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
        { 29258, "Inv_Boots_Cloth_06", "=q4=伊斯利操作長靴", "=ds=#s11#, #a1#" },
	{ 29262, "INV_Boots_Chain_05", "=q4=無盡狩獵長靴", "=ds=#s12#, #a3#", "4.00%" },
        { 32072, "INV_Gauntlets_28", "=q4=分歧護手", "=ds=#s9#, #a4#" },
        { 29359, "INV_Staff_56", "=q4=鞭叱之野性法杖", "=ds=#w9#" },
        { 24311, "INV_Scroll_05", "=q4=圖樣:白癒兜帽", "=ds=#p8# (375)", "0.30%" },
        { 0,"","","" },
        { 28371, "INV_Misc_Cape_02", "=q3=地獄之怒披風", "=ds=#s4#", "4.00%" },
        { 28342, "INV_Chest_Cloth_29", "=q3=扭曲能量外套", "=ds=#s5#, #a1#", "8.00%" },
        { 28347, "INV_Pants_Mail_21", "=q3=扭曲鱗片護腿", "=ds=#s11#, #a2#", "12.00%" },
        { 28343, "INV_Jewelry_Necklace_17", "=q3=鋸齒青褐墜飾", "=ds=#s2#", "4.00%" },
        { 28370, "INV_Jewelry_Necklace_27", "=q3=無盡祝福手鐲", "=ds=#s14#", "28.00%" },
        { 28345, "INV_Weapon_Shortblade_57", "=q3=扭曲分裂者之刺", "=ds=#h1#, #w4#", "28.00%" },
        { 28367, "INV_Sword_58", "=q3=遺棄者幻影之劍", "=ds=#h2#, #w10#", "8.00%" },
        { 28341, "INV_Staff_47", "=q3=秘法之扭曲法杖", "=ds=#w9#", "4.00%" },
	{ 30574, "INV_Jewelcrafting_Nightseye_03", "=q4=野獸黝簾石", "=ds=#e7#", "8.00%" },
	{ 30572, "INV_Jewelcrafting_Nightseye_03", "=q4=帝國黝簾石", "=ds=#e7#", "8.00%" },
	{ 30573, "INV_Jewelcrafting_Nobletopaz_03", "=q4=神秘火焰蛋白石", "=ds=#e7#", "8.00%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28229, "INV_Chest_Cloth_25", "=q3=魔法使的長袍", "=ds=#s5#, #a1# (D3)", "4.00%" },
        { 28348, "INV_Helmet_15", "=q3=月林斗篷", "=ds=#s1#, #a2# (D3)", "12.00%" },
        { 28349, "INV_Helmet_19", "=q3=惡潮頭盔", "=ds=#s1#, #a3# (D3)", "12.00%" },
        { 28228, "INV_Chest_Chain_03", "=q3=野獸領主胸甲", "=ds=#s5#, #a3# (D3)", "20.00%" },
        { 28350, "INV_Helmet_20", "=q3=勇猛頭盔", "=ds=#s1#, #a4# (D3)", "16.00%" },
        };

    TKBotTrash = {
	{ 24172, "INV_Scroll_05", "=q4=設計圖:翠綠之火王冠", "=ds=#p12# (370) =q1=#n92#", "0.27%" },
	};

        ----------------------------------
	--- Tempest Keep: The Arcatraz ---
	----------------------------------

    TKArcUnbound = {
        { 28373, "INV_Misc_Cape_14", "=q3=閃爍光環披風", "=ds=#s4#", "17.13%" },
        { 28374, "INV_Shoulder_32", "=q3=法力氛圍護肩", "=ds=#s3#, #a1#", "20.35%" },
        { 28384, "INV_Boots_Chain_09", "=q3=外域行者之靴", "=ds=#s12#, #a3#", "19.52%" },
        { 28375, "INV_Belt_23", "=q3=燃石戰鬥腰帶", "=ds=#s10#, #a4#", "14.38%" },
        { 28372, "Ability_Druid_HealingInstincts", "=q3=野獸暗影塑像", "=ds=#s16#, #w14#", "15.80%" },
        };

    TKArcUnboundHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30582, "INV_Jewelcrafting_NobleTopaz_03", "=q4=致命的火焰蛋白石", "=ds=#e7#", "0.18%" },
	{ 30575, "INV_Jewelcrafting_NobleTopaz_03", "=q4=靈巧火焰蛋白石", "=ds=#e7#", "0.18%" },
	{ 30581, "INV_Jewelcrafting_NobleTopaz_03", "=q4=持久火焰蛋白石", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 28373, "INV_Misc_Cape_14", "=q3=閃爍光環披風", "=ds=#s4#", "33.33%" },
        { 28374, "INV_Shoulder_32", "=q3=法力氛圍護肩", "=ds=#s3#, #a1#", "12.50%" },
        { 28384, "INV_Boots_Chain_09", "=q3=外域行者之靴", "=ds=#s12#, #a3#", "16.67%" },
        { 28375, "INV_Belt_23", "=q3=燃石戰鬥腰帶", "=ds=#s10#, #a4#", "16.67%" },
        { 28372, "Ability_Druid_HealingInstincts", "=q3=野獸暗影塑像", "=ds=#s16#, #w14#", "8.33%" },
        };
        
    TKArcScryer = {
        { 28396, "INV_Gauntlets_22", "=q3=解放手套", "=ds=#s9#, #a2#", "17.80%" },
        { 28398, "INV_Belt_26", "=q3=沉睡腰帶", "=ds=#s10#, #a2#", "16.29%" },
        { 28394, "INV_Jewelry_Ring_48Naxxramas", "=q3=雷恩寇的精妙指環", "=ds=#s13#", "16.81%" },
        { 28393, "INV_Mace_42", "=q3=注入光明的血錘", "=ds=#h2#, #w6#", "16.14%" },
        { 28397, "INV_Weapon_Crossbow_17", "=q3=餘燼鷹之弩", "=ds=#w3#", "17.65%" },
	};

    TKArcScryerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30582, "INV_Jewelcrafting_NobleTopaz_03", "=q4=致命的火焰蛋白石", "=ds=#e7#", "0.18%" },
	{ 30575, "INV_Jewelcrafting_NobleTopaz_03", "=q4=靈巧火焰蛋白石", "=ds=#e7#", "0.18%" },
	{ 30581, "INV_Jewelcrafting_NobleTopaz_03", "=q4=持久火焰蛋白石", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 28396, "INV_Gauntlets_22", "=q3=解放手套", "=ds=#s9#, #a2#", "20.59%" },
        { 28398, "INV_Belt_26", "=q3=沉睡腰帶", "=ds=#s10#, #a2#", "11.76%" },
        { 28394, "INV_Jewelry_Ring_48Naxxramas", "=q3=雷恩寇的精妙指環", "=ds=#s13#", "23.53%" },
	{ 28393, "INV_Mace_42", "=q3=注入光明的血錘", "=ds=#h2#, #w6#", "14.71%" },
        { 28397, "INV_Weapon_Crossbow_17", "=q3=餘燼鷹之弩", "=ds=#w3#", "8.82%" },
        };
        
    TKArcDalliah = {
        { 24308, "INV_Scroll_05", "=q4=圖樣:白癒短褲", "=ds=#p8# (375)", "0.29%" },
        { 0,"","","" },
        { 28391, "INV_Chest_Wolf", "=q3=世界之火胸甲", "=ds=#s5#, #a3#", "18.57%" },
        { 28390, "INV_Gauntlets_30", "=q3=薩堤亞自我懲戒護手", "=ds=#s9#, #a4#", "14.80%" },
        { 28387, "INV_Mace_13", "=q3=安寧和祥之棒", "=ds=#s15#", "15.92%" },
        { 28392, "INV_Weapon_Hand_08", "=q3=反射之刃", "=ds=#h3#, #w13#", "18.37%" },
        { 28386, "INV_Wand_17", "=q3=地獄核心之支配魔棒", "#w12#", "15.29%" },
        };

    TKArcDalliahHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 30582, "INV_Jewelcrafting_NobleTopaz_03", "=q4=致命的火焰蛋白石", "=ds=#e7#", "0.18%" },
	{ 30575, "INV_Jewelcrafting_NobleTopaz_03", "=q4=靈巧火焰蛋白石", "=ds=#e7#", "0.18%" },
	{ 30581, "INV_Jewelcrafting_NobleTopaz_03", "=q4=持久火焰蛋白石", "=ds=#e7#", "0.18%" },
        { 24308, "INV_Scroll_05", "=q4=圖樣:白癒短褲", "=ds=#p8# (375)", "0.29%" },
        { 0,"","","" },
        { 28391, "INV_Chest_Wolf", "=q3=世界之火胸甲", "=ds=#s5#, #a3#", "14.29%" },
        { 28390, "INV_Gauntlets_30", "=q3=薩堤亞自我懲戒護手", "=ds=#s9#, #a4#", "20.00%" },
        { 28387, "INV_Mace_13", "=q3=安寧和祥之棒", "=ds=#s15#", "20.00%" },
        { 28392, "INV_Weapon_Hand_08", "=q3=反射之刃", "=ds=#h3#, #w13#", "11.43%" },
        { 28386, "INV_Wand_17", "=q3=地獄核心之支配魔棒", "=ds=#w12#", "14.29%" },
        };
        
    TKArcHarbinger = {
	{ 28406, "INV_Boots_Cloth_04", "=q3=金邊符印之靴", "=ds=#s12#, #a1#", "12.23%" },
        { 28419, "INV_Jewelry_Necklace_30Naxxramas", "=q3=流動思慮項圈", "=ds=#s2#", "14.92%" },
        { 28407, "INV_Jewelry_Ring_AhnQiraj_04", "=q3=源質哨兵指環", "=ds=#s13#", "10.70%" },
        { 28418, "INV_Gizmo_ElementalBlastingPowder", "=q3=薩法爾之奈薩斯號角", "=ds=#s14#", "12.23%" },
	{ 28412, "INV_Offhand_OutlandRaid_03white", "=q3=安寧光輝之燈", "=ds=#s15#", "13.15%" },
	{ 28416, "INV_Weapon_Shortblade_35", "=q3=飢餓裂脊匕首", "=ds=#h1#, #w4#", "12.35%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28415, "INV_Helmet_30", "=q3=遺忘兜帽", "=ds=#s1#, #a1# (D3)", "12.23%" },
        { 28413, "INV_Jewelry_Ring_62", "=q3=神聖王冠", "=ds=#s1#, #a1# (D3)", "12.17%" },
        { 28414, "INV_Helmet_15", "=q3=刺殺頭盔", "=ds=#s1#, #a2# (D3)", "11.25%" },
        { 28231, "INV_Chest_Chain_03", "=q3=惡潮護胸", "=ds=#s5#, #a3# (D3)", "14.98%" },
        { 28403, "INV_Chest_Chain_15", "=q3=末日戰甲護胸", "=ds=#s5#, #a4# (D3)", "13.15%" },
        { 28205, "INV_Chest_Chain_15", "=q3=勇猛胸甲", "=ds=#s5#, #a4# (D3)", "11.19%" },
        };

    TKArcHarbingerHEROIC = {
        { 29434, "Spell_Holy_ChampionsBond", "=q4=正義徽章", "=ds=#e15#", "100%" },
	{ 29248, "INV_Boots_Cloth_05", "=q4=暗影足跡遠行者", "=ds=#s12#, #a2#", "0.61%" },
	{ 30534, "INV_Pants_Mail_16", "=q4=龍鱗護腿", "=ds=#s11#, #a3#", "0.49%" },
        { 29252, "INV_Bracer_02", "=q4=莊嚴護腕", "=ds=#s8#, #a4#", "3.03%" },
	{ 29254, "INV_Boots_Chain_05", "=q4=正義之路長靴", "=ds=#s12#, #a4#", "0.61%" },
	{ 29360, "INV_Weapon_Shortblade_33", "=q4=背叛者之邪惡短刃", "=ds=#h1#, #w4#", "0.18%" },
        { 0,"","","" },
	{ 28406, "INV_Boots_Cloth_04", "=q3=金邊符印之靴", "=ds=#s12#, #a1#", "9.38%" },
        { 28419, "INV_Jewelry_Necklace_30Naxxramas", "=q3=流動思慮項圈", "=ds=#s2#", "12.50%" },
        { 28407, "INV_Jewelry_Ring_AhnQiraj_04", "=q3=源質哨兵指環", "=ds=#s13#", "12.50%" },
        { 28418, "INV_Gizmo_ElementalBlastingPowder", "=q3=薩法爾之奈薩斯號角", "=ds=#s14#", "9.38%" },
	{ 28412, "INV_Offhand_OutlandRaid_03white", "=q3=安寧光輝之燈", "=ds=#s15#", "6.25%" },
	{ 28416, "INV_Weapon_Shortblade_35", "=q3=飢餓裂脊匕首", "=ds=#h1#, #w4#", "3.12%" },
        { 0,"","","" },
        { 0,"","","" },
	{ 30582, "INV_Jewelcrafting_NobleTopaz_03", "=q4=致命的火焰蛋白石", "=ds=#e7#", "0.18%" },
	{ 30575, "INV_Jewelcrafting_NobleTopaz_03", "=q4=靈巧火焰蛋白石", "=ds=#e7#", "0.18%" },
	{ 30581, "INV_Jewelcrafting_NobleTopaz_03", "=q4=持久火焰蛋白石", "=ds=#e7#", "0.18%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28415, "INV_Helmet_30", "=q3=遺忘兜帽", "=ds=#s1#, #a1# (D3)", "18.75%" },
        { 28413, "INV_Jewelry_Ring_62", "=q3=神聖王冠", "=ds=#s1#, #a1# (D3)", "12.17%" },
        { 28414, "INV_Helmet_15", "=q3=刺殺頭盔", "=ds=#s1#, #a2# (D3)", "18.75%" },
        { 28231, "INV_Chest_Chain_03", "=q3=惡潮護胸", "=ds=#s5#, #a3# (D3)", "9.38%" },
        { 28403, "INV_Chest_Chain_15", "=q3=末日戰甲護胸", "=ds=#s5#, #a4# (D3)", "12.50%" },
        { 28205, "INV_Chest_Chain_15", "=q3=勇猛胸甲", "=ds=#s5#, #a4# (D3)", "11.19%" },
        };

    TKArcTrash = {
	{ 23606, "INV_Scroll_05", "=q3=設計圖:魔鋼護腿", "=ds=#p2# (360), =q1=#n57#", "3.93%" },
        { 0,"","","" },
	{ 22556, "INV_Misc_Note_01", "=q2=公式:附魔雙手武器 - 極效敏捷", "=ds=#p4# (360) =q1=#n89#", "1.68%" },
	{ 29672, "INV_Scroll_06", "=q2=圖樣:烈焰護甲片", "=ds=#p7# (340) =q1=#n91#", "1.84%" },
	{ 21905, "INV_Scroll_06", "=q2=圖樣:奧紋護腕", "=ds=#p8# (350) =q1=#n90#", "1.21%" },
	};

        ----------------
	--- Karazhan ---
	----------------

    KaraAttumen = {
        { 28477, "INV_Bracer_13", "=q4=先驅者之環", "=ds=#s8#, #a1#", "14.68%" },
        { 28507, "INV_Gauntlets_17", "=q4=流動思緒裹手", "=ds=#s9#, #a1#", "12.44%" },
        { 28508, "INV_Gauntlets_17", "=q4=聖使祝福手套", "=ds=#s9#, #a1#", "11.69%" },
        { 28453, "INV_Bracer_02", "=q4=白雄鹿護腕", "=ds=#s8#, #a2#", "12.19%" },
        { 28506, "INV_Gauntlets_28", "=q4=敏捷操作手套", "=ds=#s9#, #a2#", "14.68%" },
        { 28503, "INV_Bracer_02", "=q4=旋風護腕", "=ds=#s8#, #a3#", "9.20%" },
        { 28454, "INV_Bracer_02", "=q4=獵捕者戰鬥護腕", "=ds=#s8#, #a3#", "16.17%" },
        { 28502, "INV_Bracer_19", "=q4=英勇臂甲", "=ds=#s8#, #a4#", "10.70%" },
        { 28505, "INV_Gauntlets_25", "=q4=希望重燃護手", "=ds=#s9#, #a4#", "10.95%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28509, "INV_Jewelry_Necklace_22", "=q4=狼爪項鏈", "=ds=#s2#", "17.16%" },
        { 28510, "INV_Jewelry_Ring_31", "=q4=經絡幽靈指環", "=ds=#s13#", "10.70%" },
        { 28504, "INV_Weapon_Crossbow_18", "=q4=鋼鷹之弩", "=ds=#w3#", "12.44%" },
        { 30480, "Ability_Mount_Dreadsteed", "=q4=熾炎戰馬韁繩", "=ds=#e12#", "0.25%" },
        { 0,"","","" },
        { 23809, "INV_Scroll_05", "=q3=結構圖:穩固恆金瞄準鏡", "=ds=#p5# (375)", "1.00%" },    
        };

    KaraMoroes = {
        { 28529, "INV_Misc_Cape_10", "=q4=阿拉希諸王皇家披風", "=ds=#s4#", "15.91%" },
        { 28570, "INV_Misc_Cape_20", "=q4=達拉然暗影披風", "=ds=#s4#", "12.18%" },
        { 28565, "INV_Belt_08", "=q4=地獄碎片腰帶", "=ds=#s10#, #a1#", "14.08%" },
        { 28545, "INV_Boots_Plate_06", "=q4=邊緣行者長靴", "=ds=#s12#, #a2#", "11.07%" },
        { 28567, "INV_Belt_22", "=q4=強力腰帶", "=ds=#s10#, #a3#", "12.05%" },
        { 28566, "INV_Belt_27", "=q4=深紅堅毅腰帶", "=ds=#s10#, #a4#", "10.81%" },
        { 28569, "INV_Boots_Chain_05", "=q4=勇氣長靴", "=ds=#s12#, #a4#", "11.33%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28530, "INV_Jewelry_Necklace_AhnQiraj_04", "=q4=不滅狂怒胸針", "=ds=#s2#", "12.25%" },
        { 28528, "INV_Misc_PocketWatch_02", "=q4=摩洛的幸運懷錶", "=ds=#s14#", "12.05%" },
        { 28525, "INV_Jewelry_Ring_60", "=q4=堅信之戒", "=ds=#s15#", "14.54%" },
        { 28568, "INV_Misc_TheGoldenCheep", "=q4=鳥類之心塑像", "=ds=#s16#, #w14#", "14.08%" },
        { 28524, "INV_Weapon_Shortblade_38", "=q4=綠寶石匕首", "=ds=#h1#, #w4#", "12.90%" },
        { 0,"","","" },
        { 22559, "INV_Misc_Note_01", "=q3=公式:附魔武器 - 雷心", "=ds=#p4# (375)", "1.05%" },
        };

    KaraMaiden = {
        { 28511, "INV_Bracer_13", "=q4=內心指環", "=ds=#s8#, #a1#", "12.46%" },
        { 28515, "INV_Bracer_13", "=q4=惡毒指環", "=ds=#s8#, #a1#", "13.87%" },
	{ 28517, "INV_Boots_Cloth_05", "=q4=預言長靴", "=ds=#s12#, #a1#", "16.96%" },
        { 28514, "INV_Bracer_15", "=q4=恨惡護腕", "=ds=#s8#, #a2#", "15.90%" },
	{ 28521, "INV_Gauntlets_25", "=q4=樹林修補者手套", "=ds=#s9#, #a2#", "13.16%" },
        { 28520, "INV_Gauntlets_25", "=q4=核心手套", "=ds=#s9#, #a3#", "13.16%" },
        { 28519, "INV_Gauntlets_25", "=q4=復甦手套", "=ds=#s9#, #a3#", "14.22%" },
        { 28512, "INV_Bracer_02", "=q4=正義護腕", "=ds=#s8#, #a4#", "10.42%" },
        { 28518, "INV_Gauntlets_31", "=q4=初新鐵護手", "=ds=#s9#, #a4#", "12.63%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28516, "INV_Jewelry_Necklace_AhnQiraj_02", "=q4=倒刺懲罰領巾", "=ds=#s2#", "11.48%" },
        { 28523, "Spell_Nature_GiftoftheWaterSpirit", "=q4=治癒大雨圖騰", "=ds=#s16#, #w15#", "14.58%" },
        { 28522, "INV_Hammer_26", "=q4=正義碎片", "=ds=#h3#, #w6#", "10.69%" },
        };
        
    KaraOperaEvent = {
        { 0, "INV_Box_01", "=q6="..AL["Shared Drops"], "" },
        { 28594, "INV_Pants_Cloth_05", "=q4=火焰試煉長褲", "=ds=#s11#, #a1#", "15.96%" },
        { 28591, "INV_Pants_Mail_15", "=q4=大地靈魂護腿", "=ds=#s11#, #a2#", "12.45%" },
        { 28589, "INV_Shoulder_36", "=q4=野獸深淵護肩", "=ds=#s3#, #a3#", "12.54%" },
        { 28593, "INV_Helmet_03", "=q4=巨型恆金頭盔", "=ds=#s1#, #a4#", "11.53%" },
        { 28590, "INV_Misc_Bandage_16", "=q4=奉獻綬帶", "=ds=#s14#", "18.41%" },
        { 28592, "INV_Relics_LibramofGrace", "=q4=贖救靈魂聖契", "=ds=#s16#, #w16#", "8.38%" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6="..BabbleBoss["The Crone"], "=q5="..AL["Wizard of Oz"] },
        { 28586, "INV_Helmet_30", "=q4=邪惡巫婆之帽", "=ds=#s1#, #a1#", "20.12%" },
        { 28585, "INV_Boots_Cloth_09", "=q4=紅寶石便鞋", "=ds=#s12#, #a1#", "25.39%" },
        { 28587, "INV_Axe_46", "=q4=繼承之斧", "=ds=#h2#, #w1#", "20.43%" },
        { 28588, "INV_Wand_16", "=q4=藍鑽石女巫魔杖", "=ds=#w12#", "17.96%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6="..BabbleBoss["Romulo & Julianne"], "=q5="..AL["Romulo & Julianne"] },
        { 28578, "INV_Chest_Cloth_43", "=q4=幻影魔袍", "=ds=#s5#, #a1#", "22.73%" },
        { 28579, "INV_Poison_MindNumbing", "=q4=羅密歐的毒藥瓶", "=ds=#s14#", "29.54%" },
        { 28572, "INV_Weapon_Shortblade_39", "=q4=報復之劍", "=ds=#h1#, #w4#", "13.52%" },
        { 28573, "INV_Sword_69", "=q4=絕望之劍", "=ds=#h2#, #w10#", "30.07%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "INV_Box_01", "=q6="..BabbleBoss["The Big Bad Wolf"], "=q5="..AL["Red Riding Hood"] },
        { 28582, "INV_Misc_Cape_18", "=q4=小紅帽披風", "=ds=#s4#", "12.85%" },
        { 28583, "INV_Helmet_04", "=q4=大野狼的頭顱", "=ds=#s1#, #a3#", "16.37%" },
        { 28584, "INV_Misc_MonsterClaw_04", "=q4=大野狼的爪子", "=ds=#h3#, #w13#", "16.12%" },
        { 28581, "INV_Weapon_Rifle_23", "=q4=屠狼者狙擊步槍", "=ds=#w5#", "22.42%" },
        };

    KaraCurator = {
        { 28612, "INV_Shoulder_25", "=q4=慰藉給予者肩甲", "=ds=#s3#, #a1#", "15.19%" },
        { 28647, "INV_Shoulder_01", "=q4=森林之風護肩", "=ds=#s3#, #a2#", "10.56%" },
        { 28631, "INV_Shoulder_14", "=q4=龍震護肩", "=ds=#s3#, #a3#", "13.47%" },
        { 28621, "INV_Pants_Plate_05", "=q4=烏瑞恩王朝護脛", "=ds=#s11#, #a4#", "11.85%" },
        { 28649, "INV_Jewelry_Ring_47", "=q4=迦羅娜的徽記之戒", "=ds=#s13#", "12.07%" },
        { 28633, "INV_Weapon_Halberd17", "=q4=無限奧義法杖", "=ds=#w9#", "12.28%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29757, "INV_Gauntlets_27", "=q4=亡靈勇士護手", "=ds=#m21# #e15#", "29.42%" },
        { 29758, "INV_Gauntlets_27", "=q4=亡靈防禦者手套", "=ds=#m21# #e15#", "23.60%" },
        { 29756, "INV_Gauntlets_27", "=q4=亡靈英雄手套", "=ds=#m21# #e15#", "21.66%" },
        };

    KaraIllhoof = {
        { 28660, "INV_Misc_Cape_20", "=q4=電鍍瑟銀披風", "=ds=#s4#", "14.63%" },
        { 28653, "INV_Misc_Cape_05", "=q4=灌注之暗藤披風", "=ds=#s4#", "10.45%" },
        { 28652, "INV_Belt_08", "=q4=意志腰帶", "=ds=#s10#, #a1#", "10.75%" },
        { 28654, "INV_Belt_03", "=q4=邪惡腰帶", "=ds=#s10#, #a1#", "11.04%" },
        { 28655, "INV_Belt_22", "=q4=自然生計腰帶", "=ds=#s10#, #a2#", "14.93%" },
        { 28656, "INV_Belt_22", "=q4=宵小腰帶", "=ds=#s10#, #a3#", "17.91%" },
        { 28662, "INV_Chest_Plate03", "=q4=聖光捆縛者胸甲", "=ds=#s5#, #a4#", "17.31%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28661, "INV_Jewelry_Ring_36", "=q4=修補者之心型指環", "=ds=#s13#", "11.64%" },
        { 28785, "INV_Trinket_Naxxramas06", "=q4=電光相容器", "=ds=#s14#", "10.75%" },
        { 28657, "INV_Weapon_Shortblade_44", "=q4=蠢人毒藥", "=ds=#h3#, #w6#", "14.63%" },
        { 28658, "INV_Staff_55", "=q4=泰瑞斯提安抑制法杖", "=ds=#w9#", "7.46%" },
        { 28659, "INV_Weapon_Shortblade_35", "=q4=薩維亞短劍", "=ds=#w11#", "13.43%" },
        { 0,"","","" },
	{ 22561, "INV_Misc_Note_01", "=q3=公式:附魔武器 - 靈魂冰霜", "=ds=#p4# (375)", "0.30%" },
        };

    KaraAran = {
        { 28672, "INV_Misc_Cape_10", "=q4=黑暗掠劫者披風", "=ds=#s4#", "11.70%" },
        { 28726, "INV_Shoulder_25", "=q4=心靈掠奪者襯肩", "=ds=#s3#, #a1#", "16.03%" },
        { 28670, "INV_Boots_05", "=q4=地獄火集會長靴", "=ds=#s12#, #a1#", "9.29%" },
        { 28663, "INV_Boots_Fabric_01", "=q4=廉正長靴", "=ds=#s12#, #a1#", "12.72%" },
        { 28669, "INV_Boots_Plate_06", "=q4=惡霸之靴", "=ds=#s12#, #a2#", "11.32%" },
        { 28671, "INV_Helmet_05", "=q4=鋼刺頭盔", "=ds=#s1#, #a3#", "12.21%" },
        { 28666, "INV_Shoulder_35", "=q4=正義尋求者肩甲", "=ds=#s3#, #a4#", "11.58%" },
        { 0,"","","" },
        { 23933, "INV_Misc_Book_06", "=q1=麥迪文的日記", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28674, "INV_Jewelry_Necklace_34", "=q4=虎爪護符", "=ds=#s2#", "11.20%" },
        { 28675, "INV_Jewelry_Ring_19", "=q4=謝爾曼納偉大之戒", "=ds=#s13#", "10.43%" },
        { 28727, "INV_Trinket_Naxxramas02", "=q4=紫羅蘭之眼墜飾", "=ds=#s14#", "15.39%" },
        { 28728, "INV_Misc_Gem_Sapphire_02", "=q4=艾藍的舒緩藍寶石", "=ds=#s15#", "12.72%" },
        { 28673, "INV_Wand_21", "=q4=提里斯法權勢魔杖", "=ds=#w12#", "7.25%" },
        { 0,"","","" },
        { 22560, "INV_Misc_Note_01", "=q3=公式:附魔武器 - 烈日火焰", "=ds=#p4# (375)", "0.76%" },
        };

    KaraNetherspite = {
        { 28744, "INV_Helmet_53", "=q4=獨心頭巾", "=ds=#s1#, #a1#", "12.91%" },
        { 28742, "INV_Pants_Cloth_13", "=q4=悔悟馬褲", "=ds=#s11#, #a1#", "10.99%" },
        { 28732, "INV_Helmet_58", "=q4=藐視兜帽", "=ds=#s1#, #a2#", "17.31%" },
        { 28741, "INV_Pants_Leather_13", "=q4=躲藏護腿", "=ds=#s11#, #a2#", "15.38%" },
        { 28735, "INV_Chest_Plate08", "=q4=大地之血胸甲", "=ds=#s5#, #a3#", "15.93%" },
        { 28740, "INV_Pants_Plate_02", "=q4=破碎搶奪者護腿", "=ds=#s11#, #a3#", "10.16%" },
        { 28743, "INV_Shoulder_29", "=q4=亞伯拉彌斯肩鎧", "=ds=#s3#, #a4#", "9.34%" },
        { 28733, "INV_Belt_22", "=q4=真實腰帶", "=ds=#s10#, #a4#", "10.44%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28731, "INV_Jewelry_Necklace_32", "=q4=閃亮地獄之鏈", "=ds=#s2#", "15.11%" },
        { 28730, "INV_Jewelry_Ring_24", "=q4=無疤祕銀指環", "=ds=#s13#", "10.99%" },
        { 28734, "INV_Misc_Gem_EbonDraenite_02", "=q4=無限可能珠寶", "=ds=#s15#", "11.64%" },
        { 28729, "INV_Sword_74", "=q4=憤怒之刃", "=ds=#h1#, #w10#", "6.32%" },
        };

    KaraChess = {
        { 28756, "INV_Crown_01", "=q4=高階君主頭飾", "=ds=#s1#, #a1#", "17.98%" },
        { 28755, "INV_Shoulder_29", "=q4=無情刀刃護肩", "=ds=#s3#, #a2#", "13.55%" },
        { 28750, "INV_Belt_26", "=q4=叛節腰帶", "=ds=#s10#, #a2#", "15.02%" },
        { 28752, "INV_Boots_Chain_05", "=q4=森林之王遠行者長靴", "=ds=#s12#, #a2#", "14.04%" },
        { 28751, "INV_Pants_Mail_15", "=q4=心火護腿", "=ds=#s11#, #a3#", "12.56%" },
        { 28746, "INV_Boots_Chain_05", "=q4=屠魔之靴", "=ds=#s12#, #a3#", "16.26%" },
        { 28748, "INV_Pants_Plate_18", "=q4=無罪腿甲", "=ds=#s11#, #a4#", "13.79%" },
        { 28747, "INV_Boots_Plate_06", "=q4=戰傷長靴", "=ds=#s12#, #a4#", "13.79%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 28745, "INV_Jewelry_Necklace_06", "=q4=勇氣祕銀項鏈", "=ds=#s2#", "12.81%" },
        { 28753, "INV_Jewelry_Ring_15", "=q4=回憶之戒", "=ds=#s13#", "12.56%" },
        { 28749, "INV_Sword_74", "=q4=君王防禦者", "=ds=#h1#, #w10#", "12.07%" },
        { 28754, "INV_Shield_31", "=q4=上古三連盾", "=ds=#w8#", "13.30%" },
	};

    KaraNightbane = {
        { 28602, "INV_Chest_Cloth_12", "=q4=長者文抄長袍", "=ds=#s5#, #a1#", "17.38%" },
        { 28600, "INV_Chest_Leather_07", "=q4=石化樹幹短衣", "=ds=#s5#, #a2#", "13.33%" },
        { 28601, "INV_Chest_Leather_06", "=q4=共謀者胸甲", "=ds=#s5#, #a2#", "10.24%" },
	{ 28599, "INV_Chest_Chain_07", "=q4=屠殺綴鱗胸甲", "=ds=#s5#, #a3#", "11.67%" },
	{ 28610, "INV_Boots_Chain_04", "=q4=兇猛迅捷之靴", "=ds=#s12#, #a3#", "15.71%" },
	{ 28597, "INV_Chest_Plate02", "=q4=潘札薩爾胸鎧", "=ds=#s5#, #a4#", "10.00%" },
	{ 28608, "INV_Boots_Plate_04", "=q4=緊急鐵行靴", "=ds=#s12#, #a4#", "9.05%" },
        { 0,"","","" },
	{ 31751, "Spell_Fire_Burnout", "=q1=熾烈徽記", "=ds=#m3#", "100%" },
	{ 24139, "INV_Enchant_EssenceMagicSmall", "=q1=微弱的祕法精華", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
	{ 28609, "INV_Jewelry_Necklace_17", "=q4=餘燼馬刺護符", "=ds=#s2#", "13.33%" },
        { 28603, "INV_Offhand_OutlandRaid_01", "=q4=暗夜毒物護符", "=ds=#s15#", "12.62%" },
        { 28604, "INV_Staff_57", "=q4=永生黑夜之杖", "=ds=#w9#", "16.67%" },
        { 28611, "INV_Shield_37", "=q4=龍心火焰盾牌", "=ds=#w8#", "13.57%" },
	{ 28606, "INV_Shield_29", "=q4=深沉黑暗之盾", "=ds=#w8#", "12.14%" },
        };

    KaraPrince = {
        { 28765, "INV_Misc_Cape_06", "=q4=純潔之心無垢斗蓬", "=ds=#s4#", "10.37%" },
        { 28766, "INV_Misc_Cape_18", "=q4=神秘紅寶石披風", "=ds=#s4#", "12.50%" },
        { 28764, "INV_Misc_Cape_17", "=q4=旅行者迷惑披風", "=ds=#s4#", "15.96%" },
        { 28762, "INV_Jewelry_Necklace_29Naxxramas", "=q4=偷取的靈魂飾物", "=ds=#s2#", "9.57%" },
        { 28763, "INV_Jewelry_Ring_08", "=q4=永生玉戒", "=ds=#s13#", "11.84%" },
        { 28757, "INV_Jewelry_Ring_AhnQiraj_05", "=q4=千印之戒", "=ds=#s13#", "12.90%" },
        { 28770, "INV_Weapon_Shortblade_41", "=q4=納斯雷茲姆心靈之刃", "=ds=#h3#, #w4#", "10.64%" },
        { 28768, "INV_Weapon_Shortblade_40", "=q4=麥察鑫匕首", "=ds=#h1#, #w4#", "9.84%" },
        { 28767, "INV_Axe_66", "=q4=斬首者", "=ds=#h3#, #w1#", "15.43%" },
        { 28773, "INV_Axe_60", "=q4=血吼之斧", "=ds=#h2#, #w1#", "12.63%" },
        { 28771, "INV_Mace_46", "=q4=聖光正義之錘", "=ds=#h3#, #w6#", "11.17%" },
        { 28772, "INV_Weapon_Bow_18", "=q4=日怒鳳凰之弓", "=ds=#w2#", "9.97%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29760, "INV_Helmet_24", "=q4=亡靈勇士頭盔", "=ds=#m21# #e15#", "23.01%" },
        { 29761, "INV_Helmet_24", "=q4=亡靈防禦者頭盔", "=ds=#m21# #e15#", "26.73%" },
        { 29759, "INV_Helmet_24", "=q4=亡靈英雄頭盔", "=ds=#m21# #e15#", "20.48%" },
        };

    KaraTrash = {
        { 30642, "INV_Misc_Cape_18", "=q4=正義披風", "=ds=#s4#", "0.22%" },
        { 30668, "INV_Gauntlets_17", "=q4=亡者之握", "=ds=#s9#, #a1#", "0.17%" },
        { 30673, "INV_Belt_03", "=q4=地獄腰帶", "=ds=#s10#, #a1#", "0.21%" },
        { 30644, "INV_Gauntlets_28", "=q4=靈巧之握", "=ds=#s9#, #a2#", "0.23%" },
        { 30674, "INV_Boots_Plate_06", "=q4=吉爾哈特遺失的長靴", "=ds=#s12#, #a2#", "0.17%" },
        { 30643, "INV_Belt_22", "=q4=追蹤者腰帶", "=ds=#s10#, #a3#", "0.19%" },
        { 30641, "INV_Boots_Plate_04", "=q4=迴避長靴", "=ds=#s12#, #a4#", "0.13%" },
	{ 0,"","","" },
	{ 21882, "Spell_Shadow_SoulLeech_3", "=q1=心願之糖", "=ds=#e8#" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
	{ 0,"","","" },
        { 30666, "INV_Jewelry_Necklace_30Naxxramas", "=q4=雷特辛失落綴飾", "=ds=#s2#", "0.18%" },
        { 30667, "INV_Jewelry_Ring_51Naxxramas", "=q4=無情風暴之戒", "=ds=#s13#", "0.17%" },
	{ 0,"","","" },
	{ 21903, "INV_Scroll_04", "=q4=圖樣:靈魂布護肩", "=ds=#p8# (375)", "0.74%" },
	{ 21904, "INV_Scroll_04", "=q4=圖樣:靈魂布外衣", "=ds=#p8# (375)", "1.07%" },
	{ 22545, "INV_Misc_Note_01", "=q2=公式:附魔靴子 - 穩固", "=ds=#p4# (370)", "0.66%" },
        };

    KaraNamed = {
        { 0, "Ability_Hunter_Pet_Spider", "=q6="..BabbleBoss["Hyakiss the Lurker"], "=q5="..AL["Spider"] },
        { 30675, "INV_Belt_03", "=q4=潛伏者腰帶", "=ds=#s10#, #a1# =q2=#m16#", "32.81%" },
        { 30676, "INV_Belt_25", "=q4=潛伏者腰帶", "=ds=#s10#, #a2# =q2=#m16#", "9.38%" },
        { 30677, "INV_Belt_03", "=q4=潛伏者腰帶", "=ds=#s10#, #a3# =q2=#m16#", "23.44%" },
        { 30678, "INV_Belt_22", "=q4=潛伏者腰帶", "=ds=#s10#, #a4# =q2=#m16#", "15.62%" },
        { 0,"","","" },
        { 0, "Ability_Hunter_Pet_Hyena", "=q6="..BabbleBoss["Rokad the Ravager"], "=q5="..AL["Darkhound"] },
        { 30684, "INV_Bracer_10", "=q4=破壞者護腕", "=ds=#s8#, #a1# =q2=#m16#", "27.78%" },
        { 30685, "INV_Bracer_07", "=q4=破壞者裹腕", "=ds=#s8#, #a2# =q2=#m16#", "11.11%" },
        { 30686, "INV_Bracer_02", "=q4=破壞者護腕", "=ds=#s8#, #a3# =q2=#m16#", "23.33%" },
        { 30687, "INV_Bracer_07", "=q4=破壞者護腕", "=ds=#s8#, #a4# =q2=#m16#", "8.89%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0, "Ability_Hunter_Pet_Bat", "=q6="..BabbleBoss["Shadikith the Glider"], "=q5="..AL["Bat"] },
        { 30680, "INV_Boots_05", "=q4=滑行裹足", "=ds=#s12#, #a1# =q2=#m16#", "9.68%" },
        { 30681, "INV_Boots_05", "=q4=滑行之靴", "=ds=#s12#, #a2# =q2=#m16#", "22.58%" },
        { 30682, "INV_Boots_Chain_05", "=q4=滑行重鎧", "=ds=#s12#, #a3# =q2=#m16#", "9.68%" },
        { 30683, "INV_Boots_Plate_04", "=q4=滑行足鎧", "=ds=#s12#, #a4# =q2=#m16#", "8.60%" },
	};

        --------------------
	--- Gruul's Lair ---
	--------------------

    GruulsLairHighKingMaulgar = {
        { 28797, "INV_Misc_Cape_16", "=q4=野蠻巨魔僧侶披風", "#s4#", "8.39%" },
        { 28799, "INV_Belt_03", "=q4=神聖鼓舞腰帶", "#s10#, #a1#", "9.98%" },
        { 28796, "INV_Helmet_58", "=q4=暗影邪惡面罩", "=ds=#s1#, #a2#", "12.93%" },
        { 28801, "INV_Helmet_23", "=q4=莫卡爾的戰爭頭盔", "=ds=#s1#, #a3#", "21.32%" },
        { 28795, "INV_Bracer_15", "=q4=劍刃氏族戰爭護腕", "=ds=#s8#, #a4#", "12.02%" },
        { 28800, "INV_Hammer_28", "=q4=那魯之錘", "=ds=#h2#, #w6#", "15.87%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29763, "INV_Shoulder_22", "=q4=亡靈勇士肩甲", "=ds=#m21# #e15#", "22.68%" },
        { 29764, "INV_Shoulder_22", "=q4=亡靈防禦者肩甲", "=ds=#m21# #e15#", "34.69%" },
        { 29762, "INV_Shoulder_22", "=q4=亡靈英雄肩甲", "=ds=#m21# #e15#", "25.62%" },
        };

    GruulGruul = {
	{ 28804, "INV_Helmet_27", "=q4=丘加利頭盔", "=ds=#s1#, #a1#", "14.96%" },
        { 28803, "INV_Helmet_15", "=q4=自然氣息兜帽", "=ds=#s1#, #a2#", "14.21%" },
        { 28828, "INV_Belt_26", "=q4=古羅縫製腰帶", "=ds=#s10#, #a2#", "11.22%" },
        { 28827, "INV_Gauntlets_25", "=q4=屠龍者護手", "=ds=#s9#, #a3#", "7.48%" },
        { 28810, "INV_Boots_Chain_05", "=q4=風剪長靴", "=ds=#s12#, #a3#", "10.22%" },
        { 28824, "INV_Gauntlets_31", "=q4=火星完美護手", "=ds=#s9#, #a4#", "12.22%" },
        { 28822, "INV_Misc_Bone_09", "=q4=戈魯爾之牙", "=ds=#s2#", "11.47%" },
        { 28823, "Spell_Shadow_UnholyFrenzy", "=q4=戈魯爾之眼", "=ds=#s14#", "6.73%" },
	{ 28830, "INV_Misc_Bone_03", "=q4=龍脊戰利品", "=ds=#s14#", "11.72%" },
        { 0,"","","" },
        { 31750, "INV_Ore_Thorium_01", "=q1=土靈徽記", "=ds=#m3#", "100%" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 29766, "INV_Pants_Plate_17", "=q4=亡靈勇士護腿", "=ds=#m21# #e15#", "23.69%" },
        { 29767, "INV_Pants_Plate_17", "=q4=亡靈防禦者護腿", "=ds=#m21# #e15#", "17.46%" },
        { 29765, "INV_Pants_Plate_17", "=q4=亡靈英雄護腿", "=ds=#m21# #e15#", "30.17%" },
        { 0,"","","" },
        { 28802, "INV_Sword_65", "=q4=血喉僧侶之劍", "=ds=#h3#, #w10#", "9.23%" },
        { 28794, "INV_Axe_64", "=q4=古羅王之斧", "=ds=#h2#, #w1#", "6.73%" },
        { 28825, "INV_Shield_30", "=q4=奧多爾遺產防禦者", "=ds=#w8#", "2.99%" },
        { 28826, "INV_Misc_AhnQirajTrinket_03", "=q4=對立飛刀", "=ds=#w11#", "16.21%" },
	};

        --------------------------------------------
	--- Hellfire Citadel: Magtheridon's Lair ---
	--------------------------------------------

    HCMagtheridon = {
        { 28777, "INV_Misc_Cape_14", "=q4=地窖潛行者披風", "=ds=#s4#" },
	{ 28780, "INV_Gauntlets_15", "=q4=嗜魂者裹手", "=ds=#s9#, #a1#" },
        { 28776, "INV_Gauntlets_19", "=q4=騙子的口才手套", "=ds=#s9#, #a2#" },
	{ 28778, "INV_Belt_20", "=q4=恐怖陷阱腰帶", "=ds=#s10#, #a3#" },
        { 28775, "INV_Helmet_58", "=q4=雷霆巨型頭盔", "=ds=#s1#, #a4#" },
        { 28779, "INV_Belt_22", "=q4=無盡圈套腰帶", "=ds=#s10#, #a4#" },
        { 28789, "INV_Elemental_Mote_Life01", "=q4=瑪瑟里頓之眼", "=ds=#s14#" },
        { 28781, "INV_Offhand_Draenei_A_01", "=q4=卡拉伯爾護符", "=ds=#s15#" },
        { 0,"","","" },
        { 28774, "INV_Weapon_Halberd16", "=q4=競技場之寬刃", "=ds=#w7#" },
        { 28782, "INV_Staff_53", "=q4=水晶之心搏動法杖", "=ds=#w9#" },
        { 29458, "INV_Shield_33", "=q4=復仇者之盾", "=ds=#w8#" },
        { 28783, "INV_Wand_20", "=q4=埃雷達爾忘卻法杖", "=ds=#w12#" },
        { 0,"","","" },
        { 0,"","","" },
        { 29754, "INV_Chest_Chain_03", "=q4=亡靈勇士胸甲", "=ds=#m21# #e15#" },
        { 29753, "INV_Chest_Chain_03", "=q4=亡靈防禦者胸甲", "=ds=#m21# #e15#" },
        { 29755, "INV_Chest_Chain_03", "=q4=亡靈英雄胸甲", "=ds=#m21# #e15#" },
        { 0,"","","" },
        { 32385, "INV_Misc_Head_Tauren_01", "=q4=瑪瑟里頓之首", "=ds=#m2#", "100%" },
        { 28791, "INV_Jewelry_Ring_71", "=q4=頑強之戒", "=q1=#m4#: =ds=#s13#" },
        { 28790, "INV_Jewelry_Ring_70", "=q4=那魯光明護衛之戒", "=q1=#m4#: =ds=#s13#" },
        { 28793, "INV_Jewelry_Ring_65", "=q4=深紅狂怒指環", "=q1=#m4#: =ds=#s13#" },
        { 28792, "Inv_Jewelry_Ring_55", "=q4=阿達歐的防禦徽記", "=q1=#m4#: =ds=#s13#" },
	};
 
        ------------------------------------------------
	--- Coilfang Reservoir: Serpentshrine Cavern ---
	------------------------------------------------

    CFRSerpentHydross = {
        { 30056, "INV_Chest_Cloth_43", "=q4=憎恨回音長袍", "=ds=#s5#, #a1#" },
        { 32516, "Inv_Bracer_13", "=q4=純淨護腕", "=ds=#s8#, #a1#" },
	{ 30050, "INV_Boots_05", "=q4=變換夢魘長靴", "=ds=#s12#, #a1#" },
	{ 30055, "INV_Shoulder_23", "=q4=怪異護肩", "=ds=#s3#, #a2#" },
	{ 30047, "INV_Bracer_02", "=q4=黑暗深淵戰爭護腕", "=ds=#s8#, #a3#" },
	{ 30054, "INV_Chest_Plate09", "=q4=首席巡邏員護甲", "=ds=#s5#, #a3#" },
        { 30048, "INV_Helmet_25", "=q4=正義明亮頭盔", "=ds=#s1#, #a4#" },
	{ 30053, "INV_Shoulder_20", "=q4=戰鬥舞者護肩", "=ds=#s3#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30052, "INV_Jewelry_Ring_51Naxxramas", "=q4=致命之戒", "=ds=#s13#" },
        { 33055, "INV_Jewelry_Ring_71", "=q4=惡意侵略指環", "=ds=#s13#" },
        { 30664, "INV_Misc_Herb_Nightmarevine", "=q4=野性之心生命根源", "=ds=#s14#, =q1=#m1# =ds=#c1#" },
	{ 30629, "INV_Trinket_Naxxramas05", "=q4=移位寶石", "=ds=#s14#" },
        { 30049, "INV_Misc_Gem_AzureDraenite_02", "=q4=深淵石", "=ds=#s15#" },
        { 30051, "INV_QirajIdol_Night", "=q4=新月女神塑像", "=ds=#s16#, #w14#" },
	};

    CFRSerpentLeotheras = {
        { 30092, "INV_Boots_Cloth_16", "=q4=逆戟鯨皮之靴", "=ds=#s12#, #a2#" },
	{ 30097, "INV_Shoulder_19", "=q4=珊瑚鉤肩甲", "=ds=#s3#, #a3#" },
        { 30091, "INV_Bracer_15", "=q4=精準遠行者護腕", "=ds=#s8#, #a3#" },
        { 30096, "INV_Belt_27", "=q4=無敵腰帶", "=ds=#s10#, #a4#" },
        { 30627, "Spell_Nature_UnrelentingStorm", "=q4=海嘯護符", "=ds=#s14#" },
        { 30095, "INV_Sword_73", "=q4=巨獸毒牙", "=ds=#h3#, #w10#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30239, "INV_Gauntlets_27", "=q4=征服勇士護手", "=ds=#m22# #e15#" },
        { 30240, "INV_Gauntlets_27", "=q4=征服防禦者手套", "=ds=#m22# #e15#" },
        { 30241, "INV_Gauntlets_27", "=q4=征服英雄手套", "=ds=#m22# #e15#" },
	};

    CFRSerpentKarathress = {
        { 30100, "INV_Boots_Fabric_01", "=q4=靈魂行者之靴", "=ds=#s12#, #a1#" },
        { 30101, "INV_Chest_Plate08", "=q4=血海盜賊的背心", "=ds=#s5#, #a2#" },
        { 30099, "INV_Misc_Noose_01", "=q4=浸濕的磨損拴繩", "=ds=#s2#" },
        { 30663, "INV_Misc_QirajiCrystal_04", "=q4=潮行者深淵胸針", "=ds=#s14#, =q1=#m1# =ds=#c7#" },
        { 30626, "INV_Gizmo_09", "=q4=亂流之測量儀", "=ds=#s14#" },
        { 30090, "INV_Mace_52", "=q4=世界破擊者", "=ds=#h2#, #w6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30245, "INV_Pants_Plate_17", "=q4=征服勇士護腿", "=ds=#m22# #e15#" },
        { 30246, "INV_Pants_Plate_17", "=q4=征服防禦者護腿", "=ds=#m22# #e15#" },
        { 30247, "INV_Pants_Plate_17", "=q4=征服英雄護腿", "=ds=#m22# #e15#" },
	};

    CFRSerpentMorogrim = {
	{ 30098, "INV_Misc_Cape_20", "=q4=鋒利鱗片戰爭披風", "=ds=#s4#" },
        { 30079, "INV_Shoulder_25", "=q4=伊利達瑞護肩", "=ds=#s3#, #a1#" },
	{ 30075, "INV_Chest_Leather_10", "=q4=先祖粗糙胸甲", "=ds=#s5#, #a2#" },
        { 30085, "INV_Shoulder_27", "=q4=堅韌追蹤者襯肩", "=ds=#s3#, #a3#" },
        { 30068, "INV_Belt_19", "=q4=召汐腰帶", "=ds=#s10#, #a3#" },
        { 30084, "INV_Shoulder_22", "=q4=銀色哨兵肩甲", "=ds=#s3#, #a4#" },
        { 30081, "INV_Boots_Plate_04", "=q4=遺忘之戰爭長靴", "=ds=#s12#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30008, "INV_Jewelry_Necklace_12", "=q4=迷失歲月墜飾", "=ds=#s2#" },
        { 30083, "INV_Jewelry_Ring_31", "=q4=靈魂分裂之戒", "=ds=#s13#" },
        { 33058, "INV_Jewelry_Ring_43", "=q4=警覺指環", "=ds=#s13#" },
        { 30720, "Spell_Nature_PoisonCleansingTotem", "=q4=蛇圍繩帶", "=ds=#s14#, =q1=#m1# =ds=#c3#" },
        { 30082, "INV_Sword_50", "=q4=艾薩拉之爪", "=ds=#h1#, #w10#" },
        { 30080, "INV_Wand_15", "=q4=那魯冷光魔棒", "=ds=#w12#" },
	};

    CFRSerpentLurker = {
        { 30064, "INV_Belt_03", "=q4=驚嘆恐懼腰帶", "=ds=#s10#, #a1#" },
        { 30067, "INV_Boots_05", "=q4=守護者絲絨靴", "=ds=#s12#, #a1#" },
        { 30062, "INV_Bracer_02", "=q4=雷姆洛斯樹叢護腕", "=ds=#s8#, #a2#" },
        { 30060, "INV_Boots_Plate_06", "=q4=便戰長靴", "=ds=#s12#, #a2#" },
        { 30066, "INV_Boots_Chain_05", "=q4=暴雨遠行之靴", "=ds=#s12#, #a3#" },
        { 30065, "INV_Chest_Plate05", "=q4=真實閃光胸鎧", "=ds=#s5#, #a4#" },
	{ 30057, "INV_Bracer_19", "=q4=消滅護腕", "=ds=#s8#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30059, "INV_Jewelry_Necklace_AhnQiraj_03", "=q4=獸性狂怒項圈", "=ds=#s2#" },
        { 30061, "INV_Jewelry_Ring_41", "=q4=先祖征服之戒", "=ds=#s13#" },
        { 33054, "INV_Jewelry_Ring_39", "=q4=丹札拉之印", "=ds=#s13#" },
        { 30665, "INV_Jewelry_Ring_07", "=q4=精神冥想耳環", "=ds=#s14#, =q1=#m1# =ds=#c5#" },
        { 30063, "INV_Relics_LibramofTruth", "=q4=絕對真相聖契", "=ds=#s16#, #w16#" },
        { 30058, "INV_Weapon_Shortblade_42", "=q4=潮汐之錘", "=ds=#h3#, #w6#" },
	};

    CFRSerpentVashj = {
        { 30107, "INV_Chest_Cloth_17", "=q4=海巫外套", "=ds=#s5#, #a1#" },
        { 30111, "INV_Shoulder_07", "=q4=符文圖騰襯肩", "=ds=#s3#, #a2#" },
        { 30106, "INV_Belt_26", "=q4=百亡腰帶", "=ds=#s10#, #a2#" },
        { 30104, "INV_Boots_Chain_12", "=q4=眼鏡蛇鞭長靴", "=ds=#s12#, #a3#" },
        { 30102, "Inv_Chest_Plate11", "=q4=海怪之心胸甲", "=ds=#s5#, #a4#" },
        { 30112, "INV_Gauntlets_20", "=q4=羞慚的光榮手套", "=ds=#s9#, #a4#" },
        { 30109, "INV_Jewelry_Ring_44", "=q4=無盡線圈之戒", "=ds=#s13#" },
        { 30110, "INV_Jewelry_Ring_35", "=q4=復甦珊瑚指環", "=ds=#s13#" },
        { 30621, "Inv_Misc_Gem_Diamond_07", "=q4=靜心棱鏡", "=ds=#s14#" },
        { 30103, "INV_Weapon_Shortblade_39", "=q4=瓦許毒牙", "=ds=#h1#, #w4#" },
        { 30108, "INV_Weapon_Shortblade_43", "=q4=聖光深淵權杖", "=ds=#h3#, #w6#" },
        { 30105, "INV_Weapon_Bow_08", "=q4=蛇脊長弓", "=ds=#w2#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30242, "INV_Helmet_24", "=q4=征服勇士頭盔", "=ds=#m22# #e15#" },
        { 30243, "INV_Helmet_24", "=q4=征服防禦者頭盔", "=ds=#m22# #e15#" },
        { 30244, "INV_Helmet_24", "=q4=征服英雄頭盔", "=ds=#m22# #e15#" },
        { 0,"","","" },
        { 32895, "INV_Scroll_05", "=q4=混亂卷軸", "=ds=#m20#" },
        { 0,"","","" },
        { 29906, "INV_Potion_100", "=q1=瓦許的殘存之瓶", "=ds=#m3#" },
	};

    CFRSerpentTrash = {
	{ 30027, "INV_Boots_Chain_08", "=q4=無盡勇氣長靴", "=ds=#s12#, #a4#" },
	{ 30022, "INV_Jewelry_Necklace_AhnQiraj_01", "=q4=冒險墜飾", "=ds=#s2#" },
        { 30620, "INV_Misc_Spyglass_02", "=q4=隱藏艦隊的小望遠鏡", "=ds=#s14#" },
	{ 30023, "Spell_Nature_EarthBind", "=q4=漩渦圖騰", "=ds=#s16#, #w15#" },
        { 30021, "INV_Staff_50", "=q4=野性之怒法杖", "=ds=#w9#" },
	{ 30025, "INV_ThrowingKnife_06", "=q4=毒蛇神殿短彎刀", "=ds=#w11#" },
        { 0,"","","" },
        { 30324, "Inv_Scroll_04", "=q4=設計圖:紅色浩劫戰靴", "=ds=#p2# (375)" },
        { 30322, "Inv_Scroll_04", "=q4=設計圖:紅色戰鬥腰帶", "=ds=#p2# (375)" },
        { 30323, "Inv_Scroll_04", "=q4=設計圖:保護者長靴", "=ds=#p2# (375)" },
        { 30321, "Inv_Scroll_04", "=q4=設計圖:守衛者腰帶", "=ds=#p2# (375)" },
        { 30280, "Inv_Scroll_04", "=q4=圖樣:衝擊腰帶", "=ds=#p8# (375)" },
        { 30282, "Inv_Scroll_04", "=q4=圖樣:衝擊長靴", "=ds=#p8# (375)" },
        { 30283, "Inv_Scroll_04", "=q4=圖樣:長路長靴", "=ds=#p8# (375)" },
        { 30281, "Inv_Scroll_04", "=q4=圖樣:長路腰帶", "=ds=#p8# (375)" },
        { 30308, "Inv_Scroll_04", "=q4=圖樣:颶風長靴", "=ds=#p7# (375)" },
        { 30304, "INV_Scroll_04", "=q4=圖樣:季風腰帶", "=ds=#p7# (375)" },
        { 30305, "Inv_Scroll_04", "=q4=圖樣:自然之擁長靴", "=ds=#p7# (375)" },
        { 30307, "Inv_Scroll_04", "=q4=圖樣:紅鷹長靴", "=ds=#p7# (375)" },
        { 30306, "Inv_Scroll_04", "=q4=圖樣:絕對黑暗長靴", "=ds=#p7# (375)" },
        { 30301, "Inv_Scroll_04", "=q4=圖樣:自然之力腰帶", "=ds=#p7# (375)" },
        { 30303, "Inv_Scroll_04", "=q4=圖樣:黑鷹腰帶", "=ds=#p7# (375)" },
        { 30302, "Inv_Scroll_04", "=q4=圖樣:暗影深淵腰帶", "=ds=#p7# (375)" },
        { 0,"","","" },
        { 30183, "INV_Elemental_Mote_Nether", "=q4=地獄漩渦", "=ds=#e6#" },
	};

        -----------------------------
	--- Tempest Keep: The Eye ---
	-----------------------------

    TKEyeVoidReaver = {
        { 29986, "INV_Helmet_14", "=q4=大工程師頭盔", "=ds=#s1#, #a1#" },
        { 29984, "INV_Belt_08", "=q4=札爾塔腰帶", "=ds=#s10#, #a2#" },
        { 29985, "INV_Pants_Mail_15", "=q4=虛空劫掠者脛甲", "=ds=#s11#, #a3#" },
	{ 29983, "INV_Helmet_03", "=q4=魔鋼戰爭頭盔", "=ds=#s1#, #a4#" },
        { 32515, "Inv_Bracer_19", "=q4=果斷護腕", "=ds=#s8#, #a4#" },
        { 30619, "INV_Misc_EngGizmos_14", "=q4=惡魔搶奪者的活塞", "=ds=#s14#" },
        { 30450, "INV_Gizmo_HardenedAdamantiteTube", "=q4=扭曲彈簧線圈", "=ds=#s14#, =q1=#m1# =ds=#c6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30248, "INV_Shoulder_22", "=q4=征服勇士肩甲", "=ds=#m22# #e15#" },
        { 30249, "INV_Shoulder_22", "=q4=征服防禦者肩甲", "=ds=#m22# #e15#" },
        { 30250, "INV_Shoulder_22", "=q4=征服英雄肩甲", "=ds=#m22# #e15#" },
	};

    TKEyeAlar = {
        { 29925, "INV_Misc_Cape_08", "=q4=鳳凰之翼披風", "=ds=#s4#" },
        { 29918, "INV_Bracer_13", "=q4=心靈風暴護腕", "=ds=#s8#, #a1#" },
        { 29947, "INV_Gauntlets_28", "=q4=灼熱掌握手套", "=ds=#s9#, #a2#" },
        { 29921, "INV_Chest_Plate03", "=q4=火羽胸甲", "=ds=#s5#, #a3#" },
        { 29922, "INV_Jewelry_Ring_61", "=q4=歐爾指環", "=ds=#s13#" },
        { 29920, "INV_Jewelry_Ring_51naxxramas", "=q4=重生鳳凰之翼", "=ds=#s13#" },
        { 30448, "Spell_Fire_Soulburn", "=q4=歐爾之爪", "=ds=#s14#, =q1=#m1# =ds=#c2#" },
        { 30447, "INV_Misc_Book_07", "=q4=火焰救贖寶典", "=ds=#s14#, =q1=#m1# =ds=#c4#" },
        { 29923, "INV_Offhand_Blood_02", "=q4=太陽之王護符", "=ds=#s15#" },
        { 29924, "INV_Axe_62", "=q4=地獄死亡之斧", "=ds=#h1#, #w1#" },
        { 32944, "Inv_Weapon_Hand_12", "=q4=鳳凰之爪", "=ds=#h3#, #w13#" },
        { 29948, "INV_Weapon_Hand_12", "=q4=鳳凰之爪", "=ds=#h4#, #w13#" },
        { 29949, "INV_Weapon_Rifle_18", "=q4=奧金蒸氣手槍", "=ds=#w5#" },
	};

    TKEyeSolarian = {
        { 29972, "INV_Pants_Cloth_05", "=q4=星術師長褲", "=ds=#s11#, #a1#" },
        { 29977, "INV_Pants_Cloth_07", "=q4=星靈馬褲", "=ds=#s11#, #a1#" },
        { 29966, "INV_Bracer_15", "=q4=死亡臂甲", "=ds=#s8#, #a2#" },
        { 29976, "INV_Gauntlets_26", "=q4=世界風暴護手", "=ds=#s9#, #a3#" },
        { 29951, "INV_Boots_Chain_04", "=q4=逐星者之靴", "=ds=#s12#, #a3#" },
        { 29965, "INV_Belt_22", "=q4=正道腰帶", "=ds=#s10#, #a4#" },
        { 29950, "INV_Pants_Plate_05", "=q4=血護衛護脛", "=ds=#s11#, #a4#" },
        { 32267, "Inv_Boots_Plate_06", "=q4=彈力戰靴", "=ds=#s12#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30446, "INV_Misc_Gem_Sapphire_01", "=q4=索拉瑞恩藍寶石", "=ds=#s14#, =q1=#m1# =ds=#c9#" },
        { 30449, "INV_Misc_Gem_Ebondraenite_01", "=q4=虛空之星飾物", "=ds=#s14#, =q1=#m1# =ds=#c8#" },
        { 29962, "INV_Weapon_Shortblade_46", "=q4=哈特拉斯", "=ds=#h1#, #w4#" },
        { 29981, "INV_Staff_52", "=q4=伊斯利生命法杖", "=ds=#w9#" },
        { 29982, "INV_Wand_15", "=q4=被遺忘之星魔杖", "=ds=#w12#" },
	};

    TKEyeKaelthas = {
        { 29989, "INV_Misc_Cape_06", "=q4=浴陽光明斗篷", "=ds=#s4#" },
        { 29994, "INV_Misc_Cape_15", "=q4=薩拉斯迷霧斗篷", "=ds=#s4#" },
        { 29992, "INV_Misc_Cape_10", "=q4=逐日者皇家披風", "=ds=#s4#" },
        { 29990, "INV_Jewelry_Ring_65", "=q4=太陽王冠", "=ds=#s1#, #a1#" },
        { 29987, "Inv_Gauntlets_17", "=q4=太陽之王護手", "=ds=#s9#, #a1#" },
        { 29995, "Inv_Pants_Leather_03", "=q4=致命意圖護腿", "=ds=#s11#, #a2#" },
        { 29991, "INV_Pants_Plate_07", "=q4=太陽之鷹護腿", "=ds=#s11#, #a3#" },
        { 29998, "INV_Gauntlets_29", "=q4=銀月皇家手套", "=ds=#s9#, #a4#" },
        { 29997, "Inv_Jewelry_Ring_55", "=q4=遊俠領袖指環", "=ds=#s13#" },
        { 29996, "INV_Mace_48", "=q4=太陽之王權杖", "=ds=#h1#, #w6#" },
        { 29993, "INV_Sword_2h_Blood_C_01", "=q4=鳳凰之雙刃劍", "=ds=#h2#, #w10#" },
        { 29988, "INV_Staff_43", "=q4=奈薩斯鑰匙", "=ds=#w9#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 30236, "INV_Chest_Chain_03", "=q4=征服勇士胸甲", "=ds=#m22# #e15#" },
        { 30237, "INV_Chest_Chain_03", "=q4=征服防禦者胸甲", "=ds=#m22# #e15#" },
        { 30238, "INV_Chest_Chain_03", "=q4=征服英雄胸甲", "=ds=#m22# #e15#" },
        { 0,"","","" },
	{ 32458, "Inv_Misc_Summerfest_Brazierorange", "=q4=歐爾骨灰", "=ds=#e12#" },
        { 0,"","","" },
        { 32405, "INV_Misc_Gem_Pearl_06", "=q4=嫩綠球體", "=ds=#m2#", "100%" },
        { 30015, "INV_Jewelry_Necklace_14", "=q4=太陽之王的墜飾", "=q1=#m4#: =ds=#s2#" },
        { 30017, "Inv_Jewelry_Necklace_30Naxxramas", "=q4=泰隆尼卡斯的暴行墜飾", "=q1=#m4#: =ds=#s2#" },
        { 30007, "Inv_Jewelry_Necklace_Ahnqiraj_04", "=q4=黑暗者護頸", "=q1=#m4#: =ds=#s2#" },
        { 30018, "INV_Jewelry_Necklace_29Naxxramas", "=q4=桑古納爾的頸鏈", "=q1=#m4#: =ds=#s2#" },
        { 0,"","","" },
        { 32896, "INV_Scroll_04", "=q4=太陽卷軸", "=ds=#m20#" },
        { 0,"","","" },
        { 29905, "INV_Potion_101", "=q1=凱爾薩斯的殘存之瓶", "=ds=#m3#" },
	};

    TKEyeTrash = {
        { 30024, "INV_Shoulder_25", "=q4=精靈王襯肩", "=ds=#s3#, #a1#" },
        { 30020, "INV_Belt_03", "=q4=法師火焰腰帶", "=ds=#s10#, #a1#" },
        { 30029, "INV_Gauntlets_25", "=q4=古老智慧的樹皮手套", "=ds=#s9#, #a2#" },
	{ 30026, "INV_Bracer_17", "=q4=神聖弓箭手指環", "=ds=#s8#, #a3#" },
        { 30030, "INV_Belt_22", "=q4=流星腰帶", "=ds=#s10#, #a3#" },
        { 30028, "INV_Jewelry_Ring_24", "=q4=堤里斯佛倫之第七指環", "=ds=#s13#" },
        { 0,"","","" },
        { 30324, "Inv_Scroll_04", "=q4=設計圖:紅色浩劫戰靴", "=ds=#p2# (375)" },
        { 30322, "Inv_Scroll_04", "=q4=設計圖:紅色戰鬥腰帶", "=ds=#p2# (375)" },
        { 30323, "Inv_Scroll_04", "=q4=設計圖:保護者長靴", "=ds=#p2# (375)" },
        { 30321, "Inv_Scroll_04", "=q4=設計圖:守衛者腰帶", "=ds=#p2# (375)" },
        { 30280, "Inv_Scroll_04", "=q4=圖樣:衝擊腰帶", "=ds=#p8# (375)" },
        { 30282, "Inv_Scroll_04", "=q4=圖樣:衝擊長靴", "=ds=#p8# (375)" },
        { 30283, "Inv_Scroll_04", "=q4=圖樣:長路長靴", "=ds=#p8# (375)" },
        { 30281, "Inv_Scroll_04", "=q4=圖樣:長路腰帶", "=ds=#p8# (375)" },
        { 30308, "Inv_Scroll_04", "=q4=圖樣:颶風長靴", "=ds=#p7# (375)" },
        { 30304, "INV_Scroll_04", "=q4=圖樣:季風腰帶", "=ds=#p7# (375)" },
        { 30305, "Inv_Scroll_04", "=q4=圖樣:自然之擁長靴", "=ds=#p7# (375)" },
        { 30307, "Inv_Scroll_04", "=q4=圖樣:紅鷹長靴", "=ds=#p7# (375)" },
        { 30306, "Inv_Scroll_04", "=q4=圖樣:絕對黑暗長靴", "=ds=#p7# (375)" },
        { 30301, "Inv_Scroll_04", "=q4=圖樣:自然之力腰帶", "=ds=#p7# (375)" },
        { 30303, "Inv_Scroll_04", "=q4=圖樣:黑鷹腰帶", "=ds=#p7# (375)" },
        { 30302, "Inv_Scroll_04", "=q4=圖樣:暗影深淵腰帶", "=ds=#p7# (375)" },
        { 0,"","","" },
        { 30183, "INV_Elemental_Mote_Nether", "=q4=地獄漩渦", "=ds=#e6#" },
	};

    TKEyeLegendaries = {
        { 30312, "INV_Weapon_Shortblade_47", "=q5=無窮之劍", "=ds=#h1#, #w4#" },
        { 30311, "INV_Sword_69", "=q5=偏斜切割者", "=ds=#h1#, #w10#" },
        { 30317, "INV_Mace_48", "=q5=宇宙灌溉者", "=ds=#h3#, #w6#" },
        { 30316, "INV_Axe_68", "=q5=毀滅", "=ds=#h2#, #w1#" },
        { 30318, "INV_Weapon_Bow_19", "=q5=虛空之絃長弓", "=ds=#w2#, =q1=#m1# =ds=#c2#" },
        { 30313, "INV_Staff_52", "=q5=瓦解之杖", "=ds=#w9#" },
        { 30314, "INV_Shield_31", "=q5=相位堡壘", "=ds=#w8#" },
        { 30319, "Spell_Arcane_Starfire", "=q5=地獄之刺", "=ds=#w17#" },
	};

        -------------------------------------
	--- Caverns of Time: Hyjal Summit ---
	-------------------------------------

    MountHyjalWinterchill = {
        { 30871, "Inv_Bracer_13", "=q4=殉難護腕", "=ds=#s8#, #a1#" },
        { 30870, "INV_Bracer_12", "=q4=荒廢手銬", "=ds=#s8#, #a1#" },
        { 30868, "INV_Bracer_08", "=q4=回春護腕", "=ds=#s8#, #a2#" },
        { 30863, "INV_Bracer_09", "=q4=致命的手銬", "=ds=#s8#, #a2#" },
        { 30869, "INV_Bracer_03", "=q4=哀嚎之風護腕", "=ds=#s8#, #a3#" }, 
        { 30864, "Inv_Bracer_02", "=q4=探路者護腕", "=ds=#s8#, #a3#" },
        { 30873, "INV_Boots_Chain_08", "=q4=止水之靴", "=ds=#s12#, #a3#" },
        { 30866, "Inv_Shoulder_65", "=q4=血污護肩", "=ds=#s3#, #a4#" },
        { 30861, "Inv_Bracer_15", "=q4=狂暴鐐銬", "=ds=#s8#, #a4#" },
        { 30862, "INV_Bracer_19", "=q4=受祝福的艾曼泰護腕", "=ds=#s8#, #a4#" },
        { 30865, "Inv_Weapon_Shortblade_59", "=q4=追蹤者之刺", "=ds=#h1#, #w4#" },
        { 30872, "Inv_Offhand_Hyjal_d_01", "=q4=黑暗秘密記事", "=ds=#s15#" },
        { 0,"","","" },
        { 32459, "INV_Potion_19", "=q1=時間定相護符", "=ds=#m3#" },
        { 0,"","","" },
        { 32303, "Inv_Scroll_04", "=q4=設計圖:雕刻焚石", "=ds=#p12# (375)" },
        { 32307, "Inv_Scroll_04", "=q4=設計圖:矇矓焚石", "=ds=#p12# (375)" },
        { 32285, "Inv_Scroll_04", "=q4=設計圖:閃亮的深紅尖晶石", "=ds=#p12# (375)" },
        { 32296, "Inv_Scroll_04", "=q4=設計圖:極佳的獅眼石", "=ds=#p12# (375)" },
        { 32295, "Inv_Scroll_04", "=q4=設計圖:神祕的獅眼石", "=ds=#p12# (375)" },
	};

    MountHyjalAnetheron = {
        { 30884, "Inv_Shoulder_68", "=q4=怨怒披風", "=ds=#s3#, #a1#" },
        { 30888, "INV_Belt_03", "=q4=安納斯隆的束縛", "=ds=#s10#, #a1#" },
        { 30885, "INV_Boots_Cloth_14", "=q4=大主教的便鞋", "=ds=#s12#, #a1#" },
        { 30879, "Inv_Belt_26", "=q4=阿里漢多先生的金幣腰帶", "=ds=#s10#, #a2#" },
        { 30886, "Inv_Boots_Wolf", "=q4=附魔皮涼鞋", "=ds=#s12#, #a2#" },
        { 30887, "INV_Chest_Mail_04", "=q4=恢復之金色胸扣", "=ds=#s5#, #a3#" },
        { 30880, "INV_Boots_Chain_09", "=q4=迅行者軟鞋", "=ds=#s12#, #a3#" },
        { 30878, "INV_Shoulder_65", "=q4=微光鐵甲襯肩", "=ds=#s3#, #a4#" },
        { 30874, "Inv_Sword_86", "=q4=堅韌意志之劍", "=ds=#h1#, #w10#" },
        { 30881, "Inv_Sword_85", "=q4=惡名之劍", "=ds=#h1#, #w10#" },
        { 30883, "Inv_Staff_60", "=q4=殘暴之柱", "=ds=#h2#, #w9#" },
        { 30882, "INV_Shield_38", "=q4=聖光堡壘", "=ds=#w8#" },
	};

    MountHyjalKazrogal = {
        { 30916, "INV_Pants_Cloth_27", "=q4=元素傳導護腿", "=ds=#s11#, #a1#" },
        { 30894, "Inv_Boots_Cloth_01", "=q4=藍色麂皮鞋", "=ds=#s12#, #a1#" },
        { 30917, "INV_Shoulder_67", "=q4=尖銳怒氣襯肩", "=ds=#s3#, #a2#" },
        { 30914, "INV_Belt_22", "=q4=新月腰帶", "=ds=#s10#, #a2#" },
        { 30891, "INV_Boots_Cloth_05", "=q4=黑羽輕靴", "=ds=#s12#, #a2#" },
        { 30892, "Inv_Shoulder_59", "=q4=野獸馴服師護肩", "=ds=#s3#, #a3#" },
        { 30919, "INV_Belt_22", "=q4=溪谷行者腰帶", "=ds=#s10#, #a3#" },
        { 30893, "INV_Pants_Mail_17", "=q4=觸日鍊甲護腿", "=ds=#s11#, #a3#" },
        { 30915, "INV_Belt_27", "=q4=沸騰狂怒腰帶", "=ds=#s10#, #a4#" },
        { 30918, "INV_Mace_57", "=q4=贖罪之錘", "=ds=#h3#, #w6#" },
        { 30889, "INV_Shield_39", "=q4=卡斯羅高堅固之心", "=ds=#w8#" },
	};

    MountHyjalAzgalor = {
        { 30895, "INV_Belt_08", "=q4=安潔莉絲塔腰帶", "=ds=#s10#, #a1#" },
        { 30899, "INV_Chest_Leather_01", "=q4=羅吉哥先生的斗篷", "=ds=#s5#, #a2#" },
        { 30898, "Inv_Pants_Leather_25", "=q4=暗中主使者馬褲", "=ds=#s11#, #a2#" },
        { 30900, "INV_Pants_Mail_15", "=q4=蝴蝶結護腿", "=ds=#s11#, #a3#" },
        { 30896, "INV_Chest_Plate02", "=q4=守衛者的榮耀", "=ds=#s5#, #a4#" },
        { 30897, "INV_Belt_28", "=q4=希望腰帶", "=ds=#s10#, #a4#" },
        { 30901, "Inv_Weapon_Shortblade_59", "=q4=無限痛苦", "=ds=#h1#, #w4#" },
        { 0,"","","" },
        { 32289, "Inv_Scroll_04", "=q4=設計圖:狂暴的蒼穹藍寶石", "=ds=#p12# (375)" },
        { 32298, "Inv_Scroll_04", "=q4=設計圖:移形影歌紫水晶", "=ds=#p12# (375)" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31092, "Inv_Gauntlets_27", "=q4=遺忘征服者護手", "=ds=#m23# #e15#" },
        { 31094, "Inv_Gauntlets_27", "=q4=遺忘保護者手套", "=ds=#m23# #e15#" },
        { 31093, "Inv_Gauntlets_27", "=q4=遺忘防禦者手套", "=ds=#m23# #e15#" },
	};

    MountHyjalArchimonde = {
        { 30913, "Inv_Chest_Cloth_49", "=q4=霍寧長袍", "=ds=#s5#, #a1#" },
        { 30912, "Inv_Pants_Cloth_14", "=q4=永恆護腿", "=ds=#s11#, #a1#" },
        { 30905, "Inv_Chest_Plate02", "=q4=午夜胸甲", "=ds=#s5#, #a2#" },
        { 30907, "INV_Chest_Chain_17", "=q4=狂熱追蹤鎖甲", "=ds=#s5#, #a3#" },
        { 30904, "Inv_Chest_Plate02", "=q4=上帝之握", "=ds=#s5#, #a4#" },
        { 30903, "Inv_Pants_Plate_21", "=q4=無盡憤怒護腿", "=ds=#s11#, #a4#" },
        { 30911, "Inv_Offhand_Draenei_a_01", "=q4=淨化權杖", "=ds=#s15#" },
        { 30910, "Inv_Sword_90", "=q4=混沌風暴之劍", "=ds=#h3#, #w10#" },
        { 30902, "INV_Sword_68", "=q4=裂地之劍", "=ds=#h2#, #w10#" },
        { 30908, "INV_Staff_54", "=q4=阿格斯使徒", "=ds=#w9#" },
        { 30909, "Inv_Shield_40", "=q4=安東尼達斯的專注庇護", "=ds=#w8#" },
        { 30906, "Inv_Weapon_Bow_30", "=q4=刺皮打擊", "=ds=#w2#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31097, "Inv_Helmet_24", "=q4=遺忘征服者頭盔", "=ds=#m23# #e15#" },
        { 31095, "Inv_Helmet_24", "=q4=遺忘保護者頭盔", "=ds=#m23# #e15#" },
        { 31096, "Inv_Helmet_24", "=q4=遺忘防禦者頭盔", "=ds=#m23# #e15#" },
	};

        --------------------
	--- Black Temple ---
	--------------------

    BTNajentus = {
        { 32239, "Inv_Boots_Cloth_16", "=q4=海浪召喚者便鞋", "=ds=#s12#, #a1#" },
        { 32240, "Inv_Helmet_94", "=q4=潮汐潛伏者面罩", "=ds=#s1#, #a2#" },
        { 32377, "Inv_Shoulder_67", "=q4=祕密襯肩", "=ds=#s5#, #a2#" },
        { 32241, "Inv_Helmet_97", "=q4=順流頭盔", "=ds=#s1#, #a3#" },
        { 32234, "INV_Gauntlets_59", "=q4=穆葛亞手套", "=ds=#s9#, #a3#" },
        { 32242, "Inv_Boots_Chain_12", "=q4=海洋憤怒之靴", "=ds=#s12#, #a3#" },
        { 32232, "INV_Bracer_14", "=q4=恆金外殼護腕", "=ds=#s8#, #a4#" },
        { 32245, "Inv_Boots_Plate_04", "=q4=潮汐踐踏者之靴", "=ds=#s12#, #a4#" },
        { 32243, "INV_Boots_Chain_08", "=q4=珍珠鑲飾戰靴", "=ds=#s12#, #a4#" },
        { 32238, "INV_Jewelry_Ring_57", "=q4=浪靜指環", "=ds=#s13#" },
        { 32247, "INV_Jewelry_Ring_60", "=q4=俘虜風暴指環", "=ds=#s13#" },
        { 32237, "Inv_Weapon_Shortblade_58", "=q4=漩渦之怒匕首", "=ds=#h1#, #w4#" },
        { 32236, "Inv_Axe_56", "=q4=潮起之斧", "=ds=#h1#, #w1#" },
        { 32248, "INV_Weapon_Halberd_20", "=q4=荒漠長戟", "=ds=#h2#, #w7#" },
        { 0,"","","" },
        { 32738, "INV_Scroll_04", "=q4=設計圖:黎明鋼鐵護腕", "=ds=#p2# (375)" },
        { 32754, "INV_Scroll_04", "=q4=圖樣:靈機護腕", "=ds=#p2# (375)" },
        { 32750, "INV_Scroll_04", "=q4=圖樣:大地生命護腕", "=ds=#p7# (375)" },
        { 32744, "INV_Scroll_04", "=q4=圖樣:生命再生護腕", "=ds=#p7# (375)" },
        { 32747, "INV_Scroll_04", "=q4=圖樣:迅擊肩甲", "=ds=#p7# (375)" },
        { 32753, "INV_Scroll_04", "=q4=圖樣:速癒襯肩", "=ds=#p8# (375)" },
	};

    BTSupremus = {
        { 32256, "Inv_Belt_03", "=q4=無盡裹腰", "=ds=#s10#, #a1#" },
        { 32252, "Inv_Chest_Leather_03", "=q4=虛空暗影外衣", "=ds=#s6#, #a2#" },
        { 32251, "Inv_Bracer_06", "=q4=精確飛行裹手", "=ds=#s8#, #a3#" },
        { 32259, "INV_Bracer_02", "=q4=風暴前夕護腕", "=ds=#s8#, #a3#" },
        { 32258, "INV_Belt_22", "=q4=博物學家的保護腰帶", "=ds=#s10#, #a3#" },
        { 32250, "Inv_Shoulder_Haremmatron_d_01", "=q4=深淵憤怒肩鎧", "=ds=#s3#, #a4#" },
        { 0,"","","" },
        { 32737, "INV_Scroll_04", "=q4=設計圖:迅鋼肩甲", "=ds=#p2# (375)" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32260, "INV_Jewelry_Necklace_36", "=q4=無盡惡夢頸圈", "=ds=#s2#" },
        { 32261, "INV_Jewelry_Ring_70", "=q4=深淵領主指環", "=ds=#s13#" },
        { 32257, "Inv_Qirajidol_Alabaster", "=q4=白鹿雕像", "=ds=#s16#, #w14#" },
        { 32254, "Inv_Axe_59", "=q4=殘暴者", "=ds=#h1#, #w1#" },
        { 32262, "Inv_Mace_44", "=q4=納斯雷茲姆虹吸之錘", "=ds=#h1#, #w6#" },
        { 32255, "Inv_Shield_38", "=q4=魔石盾牌", "=ds=#w8#" },
        { 32253, "Inv_Weapon_Crossbow_20", "=q4=軍團擊殺十字弩", "=ds=#w3#" },
	};

    BTGorefiend = {
        { 32323, "INV_Misc_Cape_Naxxramas_02", "=q4=影月毀滅者斗篷", "=ds=#s4#" },
        { 32329, "Inv_Helmet_32", "=q4=恩慈兜帽", "=ds=#s1#, #a1#" },
        { 32327, "INV_Chest_Cloth_51", "=q4=暗影議會長袍", "=ds=#s5#, #a1#" },
        { 32324, "INV_Bracer_04", "=q4=隱伏護腕", "=ds=#s8#, #a2#" },
        { 32328, "Inv_Gauntlets_24", "=q4=植物學家的生長手套", "=ds=#s9#, #a2#" },
        { 32510, "INV_Boots_Chain_01", "=q4=追蹤輕步長靴", "=ds=#s12#, #a3#" },
        { 32280, "Inv_Gauntlets_62", "=q4=強制手套", "=ds=#s9#, #a4#" },
        { 32512, "INV_Belt_28", "=q4=羅德隆陷落腰帶", "=ds=#s10#, #a4#" },
        { 0,"","","" },
        { 32746, "Inv_Scroll_04", "=q4=圖樣:迅擊護腕", "=ds=#p7# (375)" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32330, "Spell_Nature_GiftoftheWaterSpirit", "=q4=先祖引導圖騰", "=ds=#s16#, #w15#" },
        { 32348, "INV_Axe_60", "=q4=靈魂順劈斧", "=ds=#h2#, #w1#" },
        { 32326, "INV_ThrowingKnife_04", "=q4=沙拉克雙絞飛刃", "=ds=#w11#" },
        { 32325, "INV_Weapon_Rifle_21", "=q4=歸隱監護者步槍", "=ds=#w5#" },
	};

    BTBloodboil = {
        { 32337, "INV_Misc_Cape_13", "=q4=饒恕斗篷", "=ds=#s4#" },
        { 32338, "INV_Shoulder_02", "=q4=血咒護肩", "=ds=#s3#, #a1#" },
        { 32340, "INV_Chest_Cloth_35", "=q4=節制外衣", "=ds=#s5#, #a1#" },
        { 32339, "INV_Belt_24", "=q4=原始權威腰帶", "=ds=#s10#, #a2#" },
        { 32334, "Inv_Chest_Samurai", "=q4=座乘襲擊上衣", "=ds=#s5#, #a3#" },
        { 32342, "INV_Belt_27", "=q4=堅定決心腰帶", "=ds=#s10#, #a4#" },
        { 32333, "INV_Belt_33", "=q4=穩固腰帶", "=ds=#s10#, #a4#" },
        { 32341, "Inv_Pants_Plate_20", "=q4=神聖回報護腿", "=ds=#s11#, #a4#" },
        { 0,"","","" },
        { 32752, "Inv_Scroll_04", "=q4=圖樣:速癒護腕", "=ds=#p8# (375)" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32335, "INV_Jewelry_Ring_71", "=q4=強勁侵略者指環", "=ds=#s13#" },
        { 32501, "Inv_Jewelcrafting_Shadowsongamethyst_01", "=q4=影月徽記", "=ds=#s14#" },
        { 32269, "INV_Weapon_Shortblade_63", "=q4=命運使者匕首", "=ds=#h1#, #w4#" },
        { 32344, "INV_Staff_61", "=q4=純淨復甦法杖", "=ds=#w9#" },
        { 32343, "Inv_Wand_16", "=q4=多彩專注魔杖", "=ds=#w12#" },
	};

    BTAkama = {
        { 32273, "Inv_Shoulder_63", "=q4=輝煌光明襯肩", "=ds=#s3#, #a1#" },
        { 32270, "Inv_Bracer_10", "=q4=法力集中護腕", "=ds=#s8#, #a1#" },
        { 32513, "Inv_Bracer_13", "=q4=神聖權力護腕", "=ds=#s8#, #a1#" },
        { 32265, "INV_Belt_26", "=q4=暗影行者腰帶", "=ds=#s10#, #a2#" },
        { 32271, "Inv_Pants_Leather_23", "=q4=永恆自然褶裙", "=ds=#s11#, #a2#" },
        { 32264, "Inv_Shoulder_59", "=q4=隱藏捕獵者肩鎧", "=ds=#s3#, #a3#" },
        { 32275, "INV_Gauntlets_61", "=q4=靈魂行者手套", "=ds=#s9#, #a3#" },
        { 32276, "INV_Belt_13", "=q4=爍火腰帶", "=ds=#s10#, #a3#" },
        { 32279, "INV_Bracer_17", "=q4=搜捕者護腕", "=ds=#s8#, #a4#" },
        { 32278, "INV_Gauntlets_60", "=q4=沉默正義手套", "=ds=#s9#, #a4#" },
        { 32263, "Inv_Pants_Plate_07", "=q4=禁衛護腿", "=ds=#s11#, #a4#" },
        { 32268, "INV_Boots_Plate_06", "=q4=侍從長靴", "=ds=#s12#, #a4#" },
        { 32266, "Inv_Jewelry_Ring_68", "=q4=欺詐意圖指環", "=ds=#s13#" },
        { 32361, "INV_Misc_Orb_05", "=q4=盲目先知塑像", "=ds=#s15#" },
        { 0,"","","" },
        { 32739, "Inv_Scroll_04", "=q4=設計圖:黎明鋼鐵肩甲", "=ds=#p2# (375)" },
        { 32748, "INV_Scroll_04", "=q4=圖樣:電光反射護腕", "=ds=#p7# (375)" },
	};

    BTEssencofSouls = {
        { 32353, "INV_Gauntlets_63", "=q4=無窮信心手套", "=ds=#s9#, #a1#" },
        { 32351, "INV_Bracer_09", "=q4=月神加持護腕", "=ds=#s8#, #a2#" },
        { 32347, "INV_Gauntlets_65", "=q4=非難手套", "=ds=#s9#, #a2#" },
        { 32352, "INV_Boots_08", "=q4=自然守護長靴", "=ds=#s12#, #a2#" },
        { 32517, "INV_Shoulder_61", "=q4=波浪治癒者襯肩", "=ds=#s3#, #a3#" },
        { 32346, "INV_Belt_14", "=q4=骨織腰帶", "=ds=#s10#, #a3#" },
        { 32354, "INV_Helmet_96", "=q4=強能命運頭冠", "=ds=#s1#, #a4#" },
        { 32345, "INV_Boots_Plate_02", "=q4=軍團恐懼長靴", "=ds=#s12#, #a4#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 32349, "INV_Jewelry_Necklace_30", "=q4=清澈法術絲線頸鍊", "=ds=#s2#" },
        { 32362, "INV_Jewelry_Amulet_03", "=q4=泰坦項鍊", "=ds=#s2#" },
        { 32350, "INV_Misc_Gem_Ebondraenite_02", "=q4=靈光之觸", "=ds=#s15#" },
        { 32332, "INV_Mace_49", "=q4=詛咒之錘", "=ds=#h2#, #w6#" },
        { 32363, "INV_Wand_15", "=q4=那魯祝福生命魔杖", "=ds=#w12#" },
	};

    BTShahraz = {
        { 32366, "INV_Boots_Cloth_02", "=q4=黑暗主導之靴", "=ds=#s12#, #a1#" },
        { 32367, "INV_Pants_Cloth_15", "=q4=荒廢護腿", "=ds=#s11#, #a1#" },
        { 32365, "INV_Chest_Plate08", "=q4=碎心胸鎧", "=ds=#s5#, #a4#" },
        { 32370, "INV_Jewelry_Necklace_32", "=q4=娜迪納的貞潔墜飾", "=ds=#s2#" },
        { 32368, "INV_Relics_Libramofhope", "=q4=光明使者聖契", "=ds=#s16#, #w16#" },
        { 32369, "Inv_Sword_87", "=q4=殘忍之刃", "=ds=#h1#, #w10#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31101, "Inv_Shoulder_22", "=q4=遺忘征服者肩甲", "=ds=#m23# #e15#" },
        { 31103, "Inv_Shoulder_22", "=q4=遺忘保護者肩甲", "=ds=#m23# #e15#" },
        { 31102, "Inv_Shoulder_22", "=q4=遺忘防禦者肩甲", "=ds=#m23# #e15#" },
	};

    BTCouncil = {
        { 32331, "INV_Misc_Cape_20", "=q4=伊利達瑞議會披風", "=ds=#s4#" },
        { 32519, "INV_Belt_07", "=q4=神聖引導腰帶", "=ds=#s10#, #a1#" },
        { 32518, "INV_Shoulder_58", "=q4=曲葉肩甲", "=ds=#s3#, #a2#" },
        { 32376, "INV_Helmet_95", "=q4=森林徘徊者頭盔", "=ds=#s1#, #a3#" },
        { 32373, "INV_Helmet_98", "=q4=伊利達瑞粉碎者頭盔", "=ds=#a1#, #s4#" },
        { 32505, "Spell_Shadow_Charm", "=q4=背叛者的狂熱", "=ds=#s13#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31098, "Inv_Shoulder_22", "=q4=遺忘征服者護腿", "=ds=#m23# #e15#" },
        { 31100, "Inv_Shoulder_22", "=q4=遺忘保護者護腿", "=ds=#m23# #e15#" },
        { 31099, "Inv_Shoulder_22", "=q4=遺忘防禦者護腿", "=ds=#m23# #e15#" },
	};

    BTIllidanStormrage = {
        { 32524, "INV_Misc_Cape_06", "=q4=高等精靈斗篷", "=ds=#s4#" },
        { 32525, "INV_Helmet_53", "=q4=伊利達瑞高階領主兜帽", "=ds=#s1#, #a1#" },
        { 32235, "INV_Misc_Bandana_03", "=q4=被詛咒的薩格拉斯幻象頭罩", "=ds=#s1#, #a2#" },
        { 32521, "INV_Helmet_98", "=q4=頑固頭冠", "=ds=#s1#, #a4#" },
        { 32497, "INV_Jewelry_Ring_67", "=q4=怒風徽記戒指", "=ds=#s13#" },
        { 32483, "INV_Misc_Bone_Elfskull_01", "=q4=古爾丹的頭顱", "=ds=#s14#" },
        { 32496, "INV_Summerfest_Fireflower", "=q4=泰蘭妲的紀念", "=ds=#s14#" },
        { 0,"","","" },
        { 32837, "INV_Weapon_Glave_01", "=q5=埃辛諾斯戰刃", "=ds=#h3#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 32838, "INV_Weapon_Glave_01", "=q5=埃辛諾斯戰刃", "=ds=#h4#, #w10#, =q1=#m1# =ds=#c9#, #c6#" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 0,"","","" },
        { 31089, "Inv_Shoulder_22", "=q4=遺忘征服者胸甲", "=ds=#m23# #e15#" },
        { 31091, "Inv_Shoulder_22", "=q4=遺忘保護者胸甲", "=ds=#m23# #e15#" },
        { 31090, "Inv_Shoulder_22", "=q4=遺忘防禦者胸甲", "=ds=#m23# #e15#" },
        { 0,"","","" },
        { 32471, "INV_Weapon_Shortblade_62", "=q4=埃辛諾斯碎刺", "=ds=#h1#, #w4#" },
        { 32500, "INV_Mace_56", "=q4=卡拉伯爾水晶尖錘", "=ds=#h3#, #w6#" },
        { 32375, "INV_Shield_32", "=q4=埃辛諾斯之盾", "=ds=#w8#" },
        { 32374, "INV_Staff_59", "=q4=札頓姆，貪婪者之杖", "=ds=#w9#" },
        { 32336, "INV_Weapon_Bow_31", "=q4=背叛者黑弓", "=ds=#w2#" },
	};

    BTTrash = {
        { 32590, "INV_Misc_Cape_10", "=q4=虛空披風", "=ds=#s4#" },
        { 32609, "INV_Boots_Cloth_08", "=q4=神聖光芒長靴", "=ds=#s12#, #a1#" },
	{ 32589, "INV_Jewelry_Necklace_17", "=q4=地獄火墜飾", "=ds=#s12#, #a2#" },
        { 32592, "Inv_Chest_Chain_11", "=q4=無情暴風胸甲", "=ds=#s5#, #a3#" },
        { 32608, "Inv_Gauntlets_62", "=q4=劫掠者手套", "=ds=#s11#, #a4#" },
        { 32606, "INV_Belt_28", "=q4=光明先驅者腰帶", "=ds=#s10#, #a4#" },
	{ 32593, "INV_Boots_Wolf", "=q4=獸穴之后長靴", "=ds=#s2#" },
        { 32591, "INV_Jewelry_Necklace_34", "=q4=鋸齒利緣頸圈", "=ds=#s2#" },
        { 32527, "Inv_Jewelry_Ring_35", "=q4=上古知識指環", "=ds=#s13#" },
        { 32526, "INV_Jewelry_Ring_35", "=q4=蹂躪指環", "=ds=#s13#" },
        { 32943, "Inv_Mace_44", "=q4=迅鋼棍棒", "=ds=#h1#, #w6#" },
        { 0,"","","" },
        { 32736, "INV_Scroll_04", "=q4=設計圖:迅鋼護腕", "=ds=#p2# (375)" },
        { 32749, "Inv_Scroll_04", "=q4=圖樣:電光反射肩甲", "=ds=#p7# (375)" },
        { 32755, "INV_Scroll_04", "=q4=圖樣:靈機襯肩", "=ds=#p8# (375)" },
        { 32228, "INV_Jewelcrafting_EmpyreanSapphire_01", "=q4=蒼穹藍寶石", "=ds=#e7#" },
        { 32231, "INV_Jewelcrafting_Pyrestone_01", "=q4=焚石寶珠", "=ds=#e7#" },
        { 32229, "INV_Jewelcrafting_Lionseye_01", "=q4=獅眼石", "=ds=#e7#" },
        { 32249, "INV_Jewelcrafting_SeasprayEmerald_01", "=q4=海泉綠寶石", "=ds=#e7#" },
        { 32230, "INV_Jewelcrafting_ShadowsongAmethyst_01", "=q4=影歌紫水晶", "=ds=#e7#" },
        { 32227, "INV_Jewelcrafting_CrimsonSpinel_01", "=q4=深紅尖晶石", "=ds=#e7#" },
        { 0,"","","" },
        { 32428, "Spell_Shadow_Demonictactics", "=q3=黑暗之心", "=ds=#e8#" },
        { 0,"","","" },
        { 32897, "Spell_Shadow_Metamorphosis", "=q1=伊利達瑞的印記", "=ds=#m20#" },
	};

        --------------------
	--- Zul'Aman ---
	--------------------

   ZANalorakk = {
        { 0,"?","=q4=Bear Mount","=ds=#e12#" },
	};  

   ZAJanAlai = {
        { 0,"","","" },
	};  

   ZAAkilZon = {
        { 0,"","","" },
	};  

   ZAHalazzi = {
        { 0,"","","" },
	};  

   ZAJinZakk = {
        { 0,"","","" },
	};  

   ZAZuljin = {
        { 0,"","","" },
	};  

   UnknownZulAmanBoss = {
        { 0,"?","=q4=Dagger of Bad Mojo","=ds=#h1#, #w4#" },
        { 0,"?","=q4=Jin'rohk, The Great Apocalypse","=ds=#h2#, #w10#" },
        { 0,"?","=q3=Formula: Enchant Weapon - Executioner","=ds=#p4# (375)" },
	};    	
};
end
